/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.View;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RTextArea;

abstract class AbstractGutterComponent
extends JPanel {
    protected RTextArea textArea;
    protected int currentLineCount;
    private static Listener listener;

    AbstractGutterComponent(RTextArea textArea) {
        this.init();
        this.setTextArea(textArea);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        AbstractGutterComponent.getListener().install(this);
    }

    protected static Rectangle getChildViewBounds(View parent, int line, Rectangle editorRect) {
        Shape alloc = parent.getChildAllocation(line, editorRect);
        if (alloc == null) {
            return new Rectangle();
        }
        return alloc instanceof Rectangle ? (Rectangle)alloc : alloc.getBounds();
    }

    protected Gutter getGutter() {
        Container parent = this.getParent();
        return parent instanceof Gutter ? (Gutter)parent : null;
    }

    private static Listener getListener() {
        if (listener == null) {
            listener = new Listener();
        }
        return listener;
    }

    abstract void handleDocumentEvent(DocumentEvent var1);

    void handleDocumentUpdated(RDocument oldDoc, RDocument newDoc) {
    }

    protected void init() {
    }

    abstract void lineHeightsChanged();

    @Override
    public void removeNotify() {
        AbstractGutterComponent.getListener().uninstall(this);
        super.removeNotify();
    }

    public void setTextArea(RTextArea textArea) {
        int lineCount;
        this.textArea = textArea;
        int n = lineCount = textArea == null ? 0 : textArea.getLineCount();
        if (this.currentLineCount != lineCount) {
            this.currentLineCount = lineCount;
            this.repaint();
        }
    }

    static class Listener
    extends MouseAdapter {
        private boolean newArmed;

        Listener() {
        }

        void install(AbstractGutterComponent component) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setArmed((AbstractGutterComponent)e.getComponent(), false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.setArmed((AbstractGutterComponent)e.getComponent(), true);
        }

        private void setArmed(AbstractGutterComponent component, boolean armed) {
            this.newArmed = armed;
            SwingUtilities.invokeLater(() -> {
                if (component.getGutter() != null && this.newArmed != component.getGutter().isArmed()) {
                    component.getGutter().setArmed(this.newArmed);
                }
            });
        }

        void uninstall(AbstractGutterComponent component) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
    }
}

