/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.websocket.server.HandshakeRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.apache.tomcat.util.res.StringManager;

public class WsHandshakeRequest
implements HandshakeRequest {
    private static final StringManager sm = StringManager.getManager(WsHandshakeRequest.class);
    private final URI requestUri;
    private final Map<String, List<String>> parameterMap;
    private final String queryString;
    private final Principal userPrincipal;
    private final Map<String, List<String>> headers;
    private final Object httpSession;
    private volatile HttpServletRequest request;

    public WsHandshakeRequest(HttpServletRequest httpServletRequest, Map<String, String> map) {
        this.request = httpServletRequest;
        this.queryString = httpServletRequest.getQueryString();
        this.userPrincipal = httpServletRequest.getUserPrincipal();
        this.httpSession = httpServletRequest.getSession(false);
        this.requestUri = WsHandshakeRequest.buildRequestUri(httpServletRequest);
        Map map2 = httpServletRequest.getParameterMap();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(map2.size());
        for (Map.Entry object2 : map2.entrySet()) {
            hashMap.put((String)object2.getKey(), Collections.unmodifiableList(Arrays.asList((String[])object2.getValue())));
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            hashMap.put((String)entry.getKey(), Collections.singletonList((String)entry.getValue()));
        }
        this.parameterMap = Collections.unmodifiableMap(hashMap);
        Iterator<Map.Entry<Object, Object>> iterator = new CaseInsensitiveKeyMap();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            iterator.put(string, Collections.unmodifiableList(Collections.list(httpServletRequest.getHeaders(string))));
        }
        this.headers = Collections.unmodifiableMap(iterator);
    }

    public URI getRequestURI() {
        return this.requestUri;
    }

    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public boolean isUserInRole(String string) {
        if (this.request == null) {
            throw new IllegalStateException();
        }
        return this.request.isUserInRole(string);
    }

    public Object getHttpSession() {
        return this.httpSession;
    }

    void finished() {
        this.request = null;
    }

    private static URI buildRequestUri(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        if (n < 0) {
            n = 80;
        }
        if ("http".equals(string)) {
            stringBuilder.append("ws");
        } else if ("https".equals(string)) {
            stringBuilder.append("wss");
        } else if ("wss".equals(string) || "ws".equals(string)) {
            stringBuilder.append(string);
        } else {
            throw new IllegalArgumentException(sm.getString("wsHandshakeRequest.unknownScheme", new Object[]{string}));
        }
        stringBuilder.append("://");
        stringBuilder.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("ws") && n != 80 || string.equals("wss") && n != 443 || string.equals("https") && n != 443) {
            stringBuilder.append(':');
            stringBuilder.append(n);
        }
        stringBuilder.append(httpServletRequest.getRequestURI());
        if (httpServletRequest.getQueryString() != null) {
            stringBuilder.append('?');
            stringBuilder.append(httpServletRequest.getQueryString());
        }
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(sm.getString("wsHandshakeRequest.invalidUri", new Object[]{stringBuilder.toString()}), uRISyntaxException);
        }
    }
}

