/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAreaClosingImageFilter_h
#define sitkAreaClosingImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class AreaClosingImageFilter
\brief Morphological closing by attributes.

An attribute closing removes blobs according to criteria such as area. When applied to grayscale images they have the effect of filling valleys (regions darker than their surroundings) based on area while leaving the rest of the image unchanged.

This code was contributed in the Insight Journal paper

"Grayscale morphological attribute operations" by Beare R. https://doi.org/10.54294/ifvjls 

\author Richard Beare. Department of Medicine, Monash University, Melbourne, Australia.
\sa itk::simple::AreaClosing for the procedural interface
\sa itk::AreaClosingImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT AreaClosingImageFilter : public ImageFilter {
    public:
      using Self = AreaClosingImageFilter;

      /** Destructor */
      virtual ~AreaClosingImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      AreaClosingImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * \brief The size of the area opening
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLambda ( double Lambda ) { this->m_Lambda = Lambda; return *this; }

      /**
       */
      double GetLambda() const { return this->m_Lambda; }\

      /**
       * Set/Get whether the image spacing is used or not - defaults to true.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Set/Get whether the image spacing is used or not - defaults to true.
       */
      bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       */
      bool GetFullyConnected() const { return this->m_FullyConnected; }

      /** Name of this class */
      std::string GetName() const { return std::string ("AreaClosingImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_Lambda{0.0};

      /*  */
      bool  m_UseImageSpacing{true};

      /*  */
      bool  m_FullyConnected{false};


    };

    /**\
     * \brief Morphological closing by attributes.
     *
     * This function directly calls the execute method of AreaClosingImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::AreaClosingImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image AreaClosing ( const Image& image1, double lambda = 0.0, bool useImageSpacing = true, bool fullyConnected = false );

     /** @} */
}
#endif
