/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.cls;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.InheritedAnonymousClassesFrameSectionRow;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class InheritedAnonymousClassesFrameSection
extends AbstractOWLFrameSection<OWLClass, OWLClassAxiom, OWLClassExpression> {
    private static final String LABEL = "SubClass Of (Anonymous Ancestor)";
    private Set<OWLClass> processedClasses = new HashSet<OWLClass>();

    public InheritedAnonymousClassesFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLClass> frame) {
        super(editorKit, LABEL, "Anonymous Ancestor Class", frame);
    }

    @Override
    protected OWLSubClassOfAxiom createAxiom(OWLClassExpression object) {
        return null;
    }

    @Override
    public OWLObjectEditor<OWLClassExpression> getObjectEditor() {
        return null;
    }

    @Override
    protected void refill(OWLOntology ontology) {
        Set<OWLClass> clses = this.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getAncestors((OWLClass)this.getRootObject());
        clses.remove(this.getRootObject());
        for (OWLClass cls : clses) {
            for (OWLSubClassOfAxiom ax : ontology.getSubClassAxiomsForSubClass(cls)) {
                if (!ax.getSuperClass().isAnonymous()) continue;
                this.addRow(new InheritedAnonymousClassesFrameSectionRow(this.getOWLEditorKit(), this, ontology, cls, (OWLClassAxiom)ax));
            }
            for (OWLSubClassOfAxiom ax : ontology.getEquivalentClassesAxioms(cls)) {
                this.addRow(new InheritedAnonymousClassesFrameSectionRow(this.getOWLEditorKit(), this, ontology, cls, (OWLClassAxiom)ax));
            }
            this.processedClasses.add(cls);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SUPER_CLASSES, () -> this.refillInferredDoIt());
    }

    private void refillInferredDoIt() {
        OWLReasoner reasoner = this.getOWLModelManager().getReasoner();
        if (!reasoner.isConsistent()) {
            return;
        }
        if (!reasoner.isSatisfiable((OWLClassExpression)this.getRootObject())) {
            return;
        }
        Set clses = this.getReasoner().getSuperClasses((OWLClassExpression)this.getRootObject(), true).getFlattened();
        clses.remove(this.getRootObject());
        for (OWLClass cls : clses) {
            if (this.processedClasses.contains(cls)) continue;
            for (OWLOntology ontology : this.getOWLModelManager().getActiveOntology().getImportsClosure()) {
                for (OWLSubClassOfAxiom ax : ontology.getSubClassAxiomsForSubClass(cls)) {
                    OWLClassExpression superClass = ax.getSuperClass();
                    if (!superClass.isAnonymous()) continue;
                    OWLSubClassOfAxiom entailedAxiom = this.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)this.getRootObject(), superClass);
                    this.addRow(new InheritedAnonymousClassesFrameSectionRow(this.getOWLEditorKit(), this, null, cls, (OWLClassAxiom)entailedAxiom));
                }
                for (OWLSubClassOfAxiom ax : ontology.getEquivalentClassesAxioms(cls)) {
                    HashSet descs = new HashSet(ax.getClassExpressions());
                    descs.remove(this.getRootObject());
                    for (OWLClassExpression superCls : descs) {
                        if (!superCls.isAnonymous()) continue;
                        OWLSubClassOfAxiom entailedAxiom = this.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)this.getRootObject(), superCls);
                        this.addRow(new InheritedAnonymousClassesFrameSectionRow(this.getOWLEditorKit(), this, null, cls, (OWLClassAxiom)entailedAxiom));
                    }
                }
            }
        }
    }

    @Override
    public boolean canAdd() {
        return false;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && (change.getAxiom() instanceof OWLSubClassOfAxiom || change.getAxiom() instanceof OWLEquivalentClassesAxiom);
    }

    @Override
    protected void clear() {
        this.processedClasses.clear();
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLClass, OWLClassAxiom, OWLClassExpression>> getRowComparator() {
        return null;
    }
}

