/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec;

import java.util.Optional;
import org.apache.lucene.backward_codecs.lucene912.Lucene912Codec;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80CompoundFormat;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80DocValuesFormat;
import org.opensearch.knn.index.codec.KNN9120Codec.KNN9120PerFieldKnnVectorsFormat;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.KNN9120DerivedSourceReadersSupplier;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.KNN9120DerivedSourceStoredFieldsFormat;

public class KNN9120Codec
extends FilterCodec {
    private static final String NAME = "KNN9120Codec";
    private static final Codec DEFAULT_DELEGATE = new Lucene912Codec();
    private static final PerFieldKnnVectorsFormat DEFAULT_KNN_VECTOR_FORMAT = new KNN9120PerFieldKnnVectorsFormat(Optional.empty());
    private final PerFieldKnnVectorsFormat perFieldKnnVectorsFormat;
    private final StoredFieldsFormat storedFieldsFormat;
    private final MapperService mapperService;

    public KNN9120Codec() {
        this(DEFAULT_DELEGATE, DEFAULT_KNN_VECTOR_FORMAT, null);
    }

    private KNN9120Codec(Codec delegate, PerFieldKnnVectorsFormat knnVectorsFormat, MapperService mapperService) {
        super(NAME, delegate);
        this.perFieldKnnVectorsFormat = knnVectorsFormat;
        this.mapperService = mapperService;
        this.storedFieldsFormat = this.getStoredFieldsFormat();
    }

    public DocValuesFormat docValuesFormat() {
        return new KNN80DocValuesFormat(this.delegate.docValuesFormat());
    }

    public CompoundFormat compoundFormat() {
        return new KNN80CompoundFormat(this.delegate.compoundFormat());
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.perFieldKnnVectorsFormat;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    private StoredFieldsFormat getStoredFieldsFormat() {
        KNN9120DerivedSourceReadersSupplier derivedSourceReadersSupplier = new KNN9120DerivedSourceReadersSupplier(segmentReadState -> {
            if (segmentReadState.fieldInfos.hasVectorValues()) {
                return this.knnVectorsFormat().fieldsReader(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasDocValues()) {
                return this.docValuesFormat().fieldsProducer(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasPostings()) {
                return this.postingsFormat().fieldsProducer(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasNorms()) {
                return this.normsFormat().normsProducer(segmentReadState);
            }
            return null;
        });
        return new KNN9120DerivedSourceStoredFieldsFormat(this.delegate.storedFieldsFormat(), derivedSourceReadersSupplier, this.mapperService);
    }
}

