"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLPlugin = void 0;
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PPLPlugin = function (Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ppl = components.clientAction.namespaceFactory();
  const ppl = Client.prototype.ppl.prototype;
  ppl.pplQuery = ca({
    url: {
      fmt: `${_shared.PPL_ENDPOINT}`,
      params: {
        format: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ppl.sqlQuery = ca({
    url: {
      fmt: `${_shared.SQL_ENDPOINT}`,
      params: {
        format: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ppl.getDataConnectionById = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}/<%=dataconnection%>`,
      req: {
        dataconnection: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ppl.deleteDataConnection = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}/<%=dataconnection%>`,
      req: {
        dataconnection: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  ppl.createDataSource = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}`
    },
    needBody: true,
    method: 'POST'
  });
  ppl.modifyDataConnection = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}`
    },
    needBody: true,
    method: 'PATCH'
  });
  ppl.getDataConnections = ca({
    url: {
      fmt: `${_shared.OPENSEARCH_DATACONNECTIONS_API.DATACONNECTION}`
    },
    method: 'GET'
  });
};
exports.PPLPlugin = PPLPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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