/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nativeprotocol;

import org.opensearch.Version;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.transport.TransportStatus;

public abstract class NetworkMessage {
    protected final Version version;
    protected final Writeable threadContext;
    protected final long requestId;
    protected final byte status;

    NetworkMessage(ThreadContext threadContext, Version version, byte status, long requestId) {
        this.threadContext = threadContext.captureAsWriteable();
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    public Version getVersion() {
        return this.version;
    }

    public long getRequestId() {
        return this.requestId;
    }

    boolean isCompress() {
        return TransportStatus.isCompress(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }
}

