/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;

public class Exponential
extends AbstractContinousDistribution {
    protected double lambda;
    protected static Exponential shared = new Exponential(1.0, Exponential.makeDefaultGenerator());

    public Exponential(double d, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d);
    }

    public double cdf(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-d * this.lambda);
    }

    public double nextDouble() {
        return this.nextDouble(this.lambda);
    }

    public double nextDouble(double d) {
        return -Math.log(this.randomGenerator.raw()) / d;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-d * this.lambda);
    }

    public void setState(double d) {
        this.lambda = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d) {
        Exponential exponential = shared;
        synchronized (exponential) {
            return shared.nextDouble(d);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.lambda + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        Exponential exponential = shared;
        synchronized (exponential) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

