/**
 * ./src/classes/compressors.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class Compressors {
    dest: string;
    isEnabled: {
        error: boolean;
        gzip: boolean;
        lz4: boolean;
        lzma: boolean;
        lzo: boolean;
        xz: boolean;
        zstd: boolean;
    };
    source: string;
    /**
     * fast compression
     * @returns
     */
    fast(): string;
    /**
     * max
     * @returns
     */
    max(): string;
    pendrive(level?: string): string;
    /**
     * populate
     */
    populate(): Promise<void>;
    /**
     * standard
     * @returns
     */
    standard(): string;
    /**
     * check mksquashfs exists
     * @param compressor
     * @returns
     */
    private check;
    /**
     * prepareCheck
     */
    private prepareCheck;
    /**
     * removeCheck
     */
    private removeCheck;
}
