/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.signer.SignerAsyncClient;
import software.amazon.awssdk.services.signer.internal.UserAgentUtils;
import software.amazon.awssdk.services.signer.model.ListSigningJobsRequest;
import software.amazon.awssdk.services.signer.model.ListSigningJobsResponse;

public class ListSigningJobsPublisher
implements SdkPublisher<ListSigningJobsResponse> {
    private final SignerAsyncClient client;
    private final ListSigningJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSigningJobsPublisher(SignerAsyncClient client, ListSigningJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSigningJobsPublisher(SignerAsyncClient client, ListSigningJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSigningJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSigningJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSigningJobsResponseFetcher
    implements AsyncPageFetcher<ListSigningJobsResponse> {
        private ListSigningJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSigningJobsResponse> nextPage(ListSigningJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSigningJobsPublisher.this.client.listSigningJobs(ListSigningJobsPublisher.this.firstRequest);
            }
            return ListSigningJobsPublisher.this.client.listSigningJobs((ListSigningJobsRequest)((Object)ListSigningJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

