/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.stats;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.collectors.SampleAggregator;
import org.opensearch.performanceanalyzer.commons.stats.format.Formatter;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;

public class StatsReporter {
    private final List<SampleAggregator> aggregators;
    private int idxOfCollectorToReport;

    public StatsReporter(List<SampleAggregator> aggregators) {
        this.aggregators = aggregators;
        this.idxOfCollectorToReport = 0;
    }

    public boolean getNextReport(Formatter formatter) {
        if (this.aggregators == null || this.aggregators.isEmpty()) {
            return false;
        }
        SampleAggregator collector = this.aggregators.get(this.idxOfCollectorToReport);
        collector.fillValuesAndReset(formatter);
        boolean ret = true;
        ++this.idxOfCollectorToReport;
        if (this.idxOfCollectorToReport == this.aggregators.size()) {
            ret = false;
            this.idxOfCollectorToReport = 0;
        }
        return ret;
    }

    @VisibleForTesting
    public boolean isMeasurementCollected(MeasurementSet measure) {
        for (SampleAggregator aggregator : this.aggregators) {
            if (!aggregator.isMeasurementObserved(measure)) continue;
            return true;
        }
        return false;
    }
}

