function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { forwardRef, memo } from 'react';
import classnames from 'classnames';
import { EuiDataGridCell } from './data_grid_cell';
import { EuiText } from '../text';
var DefaultColumnFormatter = function DefaultColumnFormatter(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React.createElement(EuiText, null, children);
};
var EuiDataGridFooterRow = /*#__PURE__*/memo(/*#__PURE__*/forwardRef(function (_ref2, ref) {
  var leadingControlColumns = _ref2.leadingControlColumns,
    trailingControlColumns = _ref2.trailingControlColumns,
    columns = _ref2.columns,
    schema = _ref2.schema,
    popoverContents = _ref2.popoverContents,
    columnWidths = _ref2.columnWidths,
    defaultColumnWidth = _ref2.defaultColumnWidth,
    className = _ref2.className,
    renderCellValue = _ref2.renderCellValue,
    rowIndex = _ref2.rowIndex,
    interactiveCellId = _ref2.interactiveCellId,
    _dataTestSubj = _ref2['data-test-subj'],
    _ref2$visibleRowIndex = _ref2.visibleRowIndex,
    visibleRowIndex = _ref2$visibleRowIndex === void 0 ? rowIndex : _ref2$visibleRowIndex,
    rest = _objectWithoutProperties(_ref2, ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "popoverContents", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "rowIndex", "interactiveCellId", "data-test-subj", "visibleRowIndex"]);
  var classes = classnames('euiDataGridRow', 'euiDataGridFooter', className);
  var dataTestSubj = classnames('dataGridRow', _dataTestSubj);
  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref,
    role: "row",
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (_ref3, i) {
    var id = _ref3.id,
      width = _ref3.width;
    return /*#__PURE__*/React.createElement(EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: i,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: width,
      renderCellValue: function renderCellValue() {
        return null;
      },
      interactiveCellId: interactiveCellId,
      isExpandable: true,
      className: "euiDataGridFooterCell euiDataGridRowCell--controlColumn"
    });
  }), columns.map(function (_ref4, i) {
    var id = _ref4.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var popoverContent = columnType && popoverContents[columnType] || DefaultColumnFormatter;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return /*#__PURE__*/React.createElement(EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      popoverContent: popoverContent,
      width: width || undefined,
      renderCellValue: renderCellValue,
      interactiveCellId: interactiveCellId,
      isExpandable: true,
      className: "euiDataGridFooterCell"
    });
  }), trailingControlColumns.map(function (_ref5, i) {
    var id = _ref5.id,
      width = _ref5.width;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return /*#__PURE__*/React.createElement(EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: width,
      renderCellValue: function renderCellValue() {
        return null;
      },
      interactiveCellId: interactiveCellId,
      isExpandable: true,
      className: "euiDataGridFooterCell euiDataGridRowCell--controlColumn"
    });
  }));
}));
EuiDataGridFooterRow.displayName = 'EuiDataGridFooterRow';
export { EuiDataGridFooterRow };