/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.utils;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.QuarkusGradleModelFactory;
import io.quarkus.bootstrap.util.BootstrapUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.logging.Logger;

public class BuildToolHelper {
    private static final Logger log = Logger.getLogger(BuildToolHelper.class);
    private static final String[] DEVMODE_REQUIRED_TASKS = new String[]{"classes"};
    private static final String[] TEST_REQUIRED_TASKS = new String[]{"classes", "testClasses", "integrationTestClasses"};
    private static final List<String> ENABLE_JAR_PACKAGING = List.of("-Dorg.gradle.java.compile-classpath-packaging=true");

    private BuildToolHelper() {
    }

    public static Path getProjectDir(Path p) {
        for (Path currentPath = p; currentPath != null; currentPath = currentPath.getParent()) {
            if (!BuildTool.MAVEN.exists(currentPath) && !BuildTool.GRADLE.exists(currentPath)) continue;
            return currentPath;
        }
        log.warnv("Unable to find a project directory for {0}.", (Object)p);
        return null;
    }

    public static BuildTool findBuildTool(Path project) {
        for (Path currentPath = project; currentPath != null; currentPath = currentPath.getParent()) {
            if (BuildTool.MAVEN.exists(currentPath)) {
                return BuildTool.MAVEN;
            }
            if (!BuildTool.GRADLE.exists(currentPath)) continue;
            return BuildTool.GRADLE;
        }
        log.warnv("Unable to find a build tool in {0} or in any parent.", (Object)project);
        return null;
    }

    public static boolean isMavenProject(Path project) {
        return BuildToolHelper.findBuildTool(project) == BuildTool.MAVEN;
    }

    public static boolean isGradleProject(Path project) {
        return BuildToolHelper.findBuildTool(project) == BuildTool.GRADLE;
    }

    public static Path getBuildFile(Path project, BuildTool tool) {
        for (Path currentPath = project; currentPath != null; currentPath = currentPath.getParent()) {
            if (!tool.exists(currentPath)) continue;
            return currentPath;
        }
        return null;
    }

    public static ApplicationModel enableGradleAppModelForTest(Path projectRoot) throws IOException, AppModelResolverException {
        return BuildToolHelper.enableGradleAppModel(projectRoot, "TEST", ENABLE_JAR_PACKAGING, TEST_REQUIRED_TASKS);
    }

    public static ApplicationModel enableGradleAppModelForProdMode(Path projectRoot) throws IOException, AppModelResolverException {
        return BuildToolHelper.enableGradleAppModel(projectRoot, "NORMAL", List.of(), new String[0]);
    }

    public static ApplicationModel enableGradleAppModel(Path projectRoot, String mode, List<String> jvmArgs, String ... tasks) throws IOException, AppModelResolverException {
        if (BuildToolHelper.isGradleProject(projectRoot)) {
            log.infof("Loading Quarkus Gradle application model for %s", (Object)projectRoot);
            ApplicationModel model = QuarkusGradleModelFactory.create((File)BuildToolHelper.getBuildFile(projectRoot, BuildTool.GRADLE).toFile(), (String)mode, jvmArgs, (String[])tasks);
            BootstrapUtils.exportModel((ApplicationModel)model, (boolean)"TEST".equalsIgnoreCase(mode));
            return model;
        }
        return null;
    }

    public static ApplicationModel enableGradleAppModelForDevMode(Path projectRoot) throws IOException, AppModelResolverException {
        if (BuildToolHelper.isGradleProject(projectRoot)) {
            ApplicationModel model = QuarkusGradleModelFactory.createForTasks((File)BuildToolHelper.getBuildFile(projectRoot, BuildTool.GRADLE).toFile(), (String[])DEVMODE_REQUIRED_TASKS);
            BootstrapUtils.exportModel((ApplicationModel)model, (boolean)false);
            return model;
        }
        return null;
    }

    public static enum BuildTool {
        MAVEN("pom.xml"),
        GRADLE("build.gradle", "build.gradle.kts");

        private final String[] buildFiles;

        private BuildTool(String ... buildFile) {
            this.buildFiles = buildFile;
        }

        public String[] getBuildFiles() {
            return this.buildFiles;
        }

        public boolean exists(Path root) {
            for (String buildFile : this.buildFiles) {
                if (!Files.exists(root.resolve(buildFile), new LinkOption[0])) continue;
                return true;
            }
            return false;
        }
    }
}

