/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.io.OutputStream;

public class OutputChunked
extends Output {
    public OutputChunked() {
        super(2048);
    }

    public OutputChunked(int bufferSize) {
        super(bufferSize);
    }

    public OutputChunked(OutputStream outputStream) {
        super(outputStream, 2048);
    }

    public OutputChunked(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
    }

    public void flush() throws KryoException {
        if (this.position() > 0) {
            try {
                this.writeChunkSize();
            }
            catch (IOException ex) {
                throw new KryoException(ex);
            }
        }
        super.flush();
    }

    private void writeChunkSize() throws IOException {
        int size = this.position();
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Write chunk: " + size));
        }
        OutputStream outputStream = this.getOutputStream();
        if ((size & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        if (((size >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(size);
            return;
        }
        outputStream.write(size & 0x7F | 0x80);
        outputStream.write(size >>>= 7);
    }

    public void endChunks() {
        this.flush();
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)"End chunks.");
        }
        try {
            this.getOutputStream().write(0);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }
}

