/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import com.hierynomus.sshj.userauth.certificate.Certificate;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.kex.AbstractDH;
import net.schmizz.sshj.transport.kex.DHBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHG
extends AbstractDH {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractDHG(DHBase dhBase, Digest digest) {
        super(dhBase, digest);
    }

    @Override
    public void init(Transport trans, String V_S, String V_C, byte[] I_S, byte[] I_C) throws GeneralSecurityException, TransportException {
        super.init(trans, V_S, V_C, I_S, I_C);
        this.digest.init();
        this.initDH(this.dh);
        this.log.debug("Sending SSH_MSG_KEXDH_INIT");
        trans.write((SSHPacket)new SSHPacket(Message.KEXDH_INIT).putBytes(this.dh.getE()));
    }

    @Override
    public boolean next(Message msg, SSHPacket packet) throws GeneralSecurityException, TransportException {
        byte[] sig;
        byte[] f;
        byte[] K_S;
        if (msg != Message.KEXDH_31) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "Unexpected packet: " + (Object)((Object)msg));
        }
        this.log.debug("Received SSH_MSG_KEXDH_REPLY");
        try {
            K_S = packet.readBytes();
            f = packet.readBytes();
            sig = packet.readBytes();
            this.hostKey = new Buffer.PlainBuffer(K_S).readPublicKey();
        }
        catch (Buffer.BufferException be) {
            throw new TransportException(be);
        }
        this.dh.computeK(f);
        Buffer.PlainBuffer buf = (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)this.initializedBuffer().putString(K_S)).putBytes(this.dh.getE())).putBytes(f)).putMPInt(this.dh.getK());
        this.digest.update(buf.array(), buf.rpos(), buf.available());
        this.H = this.digest.digest();
        Signature signature = this.trans.getHostKeyAlgorithm().newSignature();
        if (this.hostKey instanceof Certificate) {
            signature.initVerify((PublicKey)((Certificate)this.hostKey).getKey());
        } else {
            signature.initVerify(this.hostKey);
        }
        signature.update(this.H, 0, this.H.length);
        if (!signature.verify(sig)) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange signature verification failed");
        }
        this.verifyCertificate(K_S);
        return true;
    }

    private void verifyCertificate(byte[] K_S) throws TransportException {
        if (this.hostKey instanceof Certificate && this.trans.getConfig().isVerifyHostKeyCertificates()) {
            String caKeyType;
            String signatureType;
            Certificate hostKey = (Certificate)this.hostKey;
            try {
                signatureType = new Buffer.PlainBuffer(hostKey.getSignature()).readString();
            }
            catch (Buffer.BufferException e) {
                signatureType = null;
            }
            try {
                caKeyType = new Buffer.PlainBuffer(hostKey.getSignatureKey()).readString();
            }
            catch (Buffer.BufferException e) {
                caKeyType = null;
            }
            this.log.debug("Verifying signature of the key with type {} (signature type {}, CA key type {})", new Object[]{hostKey.getType(), signatureType, caKeyType});
            try {
                String certError = KeyType.CertUtils.verifyHostCertificate(K_S, hostKey, this.trans.getRemoteHost());
                if (certError != null) {
                    throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange certificate check failed: " + certError);
                }
            }
            catch (Buffer.BufferException | SSHRuntimeException e) {
                throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange certificate check failed", e);
            }
        }
    }

    protected abstract void initDH(DHBase var1) throws GeneralSecurityException;
}

