/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseFunction;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseProcedure;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseSchema;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class KingbaseFunctionManager
extends SQLObjectEditor<KingbaseFunction, KingbaseSchema>
implements DBEObjectRenamer<KingbaseFunction> {
    @Nullable
    public DBSObjectCache<KingbaseSchema, KingbaseFunction> getObjectsCache(KingbaseFunction object) {
        KingbaseSchema schema = (KingbaseSchema)object.getContainer();
        return schema.getKingbaseFunctionsCache();
    }

    public boolean canCreateObject(@NotNull Object container) {
        return container instanceof PostgreSchema && ((PostgreSchema)container).getDataSource().getServerType().supportsFunctionCreate();
    }

    public boolean canDeleteObject(@NotNull KingbaseFunction object) {
        return ((PostgreDataSource)object.getDataSource()).getServerType().supportsFunctionCreate();
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((KingbaseFunction)command.getObject()).getName())) {
            throw new DBException("Function name cannot be empty");
        }
    }

    protected KingbaseFunction createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new KingbaseFunction((PostgreSchema)container);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (KingbaseProcedure)command.getObject());
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(actionList, (KingbaseProcedure)command.getObject());
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        String objectType = ((KingbaseFunction)command.getObject()).getProcedureTypeName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop function", "DROP " + objectType + " " + ((KingbaseFunction)command.getObject()).getFullQualifiedSignature()));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actions, KingbaseProcedure procedure) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create function", procedure.getBody(), true));
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<KingbaseFunction, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        boolean isDDL;
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment function", "COMMENT ON " + ((KingbaseFunction)command.getObject()).getProcedureTypeName() + " " + ((KingbaseFunction)command.getObject()).getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((KingbaseFunction)command.getObject()).getDescription())));
        }
        if (isDDL = CommonUtils.getOption(options, (String)"ddl.source")) {
            try {
                PostgreUtils.getObjectGrantPermissionActions((DBRProgressMonitor)monitor, (PostgrePrivilegeOwner)((PostgrePrivilegeOwner)command.getObject()), actions, options);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull KingbaseFunction object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        KingbaseProcedure procedure = (KingbaseProcedure)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename function", "ALTER " + ((KingbaseFunction)command.getObject()).getProcedureTypeName() + " " + DBUtils.getQuotedIdentifier((DBSObject)procedure.getSchema()) + "." + KingbaseProcedure.makeOverloadedName(procedure.getSchema(), command.getOldName(), (List<PostgreProcedureParameter>)procedure.getParameters(monitor), true, false, false) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)procedure.getDataSource(), (String)command.getNewName())));
    }
}

