/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.knopflerfish.framework.BundleURLStreamHandler;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FWResourceURLStreamHandler;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ReferenceURLStreamHandler;
import org.knopflerfish.framework.URLStreamHandlerWrapper;
import org.knopflerfish.framework.Util;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

public class ServiceURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    Vector<FrameworkContext> framework = new Vector(2);
    Hashtable<String, URLStreamHandler> handlers = new Hashtable();
    String[] jvmPkgs = null;
    HashMap<String, URLStreamHandlerWrapper> wrapMap = new HashMap();
    BundleURLStreamHandler bundleHandler;
    private Debug debug = null;

    ServiceURLStreamHandlerFactory() {
        String s = System.getProperty("java.protocol.handler.pkgs");
        if (s != null) {
            this.jvmPkgs = Util.splitwords(s, "|");
            for (int i = 0; i < this.jvmPkgs.length; ++i) {
                this.jvmPkgs[i] = this.jvmPkgs[i].trim();
            }
        }
        this.setURLStreamHandler("fwresource", new FWResourceURLStreamHandler());
        this.setURLStreamHandler("reference", ReferenceURLStreamHandler.INSTANCE);
        this.bundleHandler = new BundleURLStreamHandler();
        this.setURLStreamHandler("bundle", this.bundleHandler);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler;
        Debug doDebug = this.debug;
        if (doDebug != null && !doDebug.url) {
            doDebug = null;
        }
        if (doDebug != null) {
            doDebug.println("createURLStreamHandler protocol=" + protocol);
        }
        if ((handler = this.getJVMClassPathHandler(protocol)) != null) {
            if (doDebug != null) {
                doDebug.println("using JVMClassPath handler for " + protocol);
            }
            return handler;
        }
        handler = this.handlers.get(protocol);
        if (handler != null) {
            if (doDebug != null) {
                doDebug.println("using predefined handler for " + protocol);
            }
            return handler;
        }
        handler = this.getServiceHandler(protocol);
        if (handler != null) {
            if (doDebug != null) {
                doDebug.println("Using service URLHandler for " + protocol);
            }
            return handler;
        }
        if (doDebug != null) {
            doDebug.println("Using default URLHandler for " + protocol);
        }
        return null;
    }

    void setURLStreamHandler(String protocol, URLStreamHandler handler) {
        this.handlers.put(protocol, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFramework(FrameworkContext fw) {
        this.bundleHandler.addFramework(fw);
        HashMap<String, URLStreamHandlerWrapper> hashMap = this.wrapMap;
        synchronized (hashMap) {
            if (this.debug == null) {
                this.debug = fw.debug;
            }
            this.framework.add(fw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFramework(FrameworkContext fw) {
        this.bundleHandler.removeFramework(fw);
        HashMap<String, URLStreamHandlerWrapper> hashMap = this.wrapMap;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, URLStreamHandlerWrapper>> i = this.wrapMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, URLStreamHandlerWrapper> e = i.next();
                if (!e.getValue().removeFramework(fw)) continue;
                i.remove();
            }
            this.framework.remove(fw);
            if (this.debug == fw.debug) {
                this.debug = this.framework.isEmpty() ? null : this.framework.get((int)0).debug;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URLStreamHandler getServiceHandler(String protocol) {
        try {
            FrameworkContext sfw;
            ServiceReference<?>[] srl;
            String filter = "(url.handler.protocol=" + protocol + ")";
            Vector sfws = (Vector)this.framework.clone();
            Iterator i$ = sfws.iterator();
            do {
                if (!i$.hasNext()) return null;
                sfw = (FrameworkContext)i$.next();
            } while ((srl = sfw.services.get(URLStreamHandlerService.class.getName(), filter, sfw.systemBundle, false)) == null || srl.length <= 0);
            HashMap<String, URLStreamHandlerWrapper> hashMap = this.wrapMap;
            synchronized (hashMap) {
                URLStreamHandlerWrapper wrapper = this.wrapMap.get(protocol);
                if (wrapper == null) {
                    wrapper = new URLStreamHandlerWrapper(sfw, protocol);
                    this.wrapMap.put(protocol, wrapper);
                } else {
                    wrapper.addFramework(sfw);
                }
                return wrapper;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Failed to get service: " + e);
        }
    }

    private URLStreamHandler getJVMClassPathHandler(String protocol) {
        Debug doDebug = this.debug;
        if (doDebug != null && !doDebug.url) {
            doDebug = null;
        }
        if (this.jvmPkgs != null) {
            for (String jvmPkg : this.jvmPkgs) {
                String className = jvmPkg + "." + protocol + ".Handler";
                try {
                    if (doDebug != null) {
                        doDebug.println("JVMClassPath - trying URLHandler class=" + className);
                    }
                    Class<?> clazz = Class.forName(className);
                    URLStreamHandler handler = (URLStreamHandler)clazz.newInstance();
                    if (doDebug != null) {
                        doDebug.println("JVMClassPath - created URLHandler class=" + className);
                    }
                    return handler;
                }
                catch (Throwable t) {
                    if (doDebug == null) continue;
                    doDebug.println("JVMClassPath - no URLHandler class " + className);
                }
            }
        }
        if (doDebug != null) {
            doDebug.println("JVMClassPath - no URLHandler for " + protocol);
        }
        return null;
    }
}

