/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class GDIComment
extends EMFTag {
    private int type;
    private String comment = "";
    private Image image;

    public GDIComment() {
        super(70, 1);
    }

    public GDIComment(String comment) {
        this();
        this.comment = comment;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        GDIComment result = new GDIComment();
        int l = emf.readDWORD();
        result.type = emf.readDWORD();
        if (result.type == 726027589) {
            emf.readByte(l - 4);
            if (l % 4 != 0) {
                emf.readBYTE(4 - l % 4);
            }
        } else if (result.type == 2) {
            emf.readRECTL();
            int nDescription = emf.readDWORD();
            if (nDescription > 0) {
                result.comment = new String(emf.readByte(nDescription));
            }
        } else if (result.type != 3) {
            if (result.type == 0x40000004) {
                emf.readRECTL();
                emf.readDWORD();
                l = l - 4 - 8;
                result.comment = new String(emf.readBYTE(l));
                if (l % 4 != 0) {
                    emf.readBYTE(4 - l % 4);
                }
            } else {
                if (result.type == -2147483647) {
                    emf.readDWORD();
                    emf.readDWORD();
                    emf.readDWORD();
                    int size = emf.readDWORD();
                    byte[] bytes = emf.readByte(size);
                    result.image = ImageIO.read(new ByteArrayInputStream(bytes));
                    return this;
                }
                if ((l -= 4) > 0) {
                    result.comment = new String(emf.readBYTE(l));
                    if (l % 4 != 0) {
                        emf.readBYTE(4 - l % 4);
                    }
                } else {
                    this.comment = "";
                }
            }
        }
        return result;
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        byte[] b = this.comment.getBytes();
        emf.writeDWORD(b.length);
        emf.writeBYTE(b);
        if (b.length % 4 != 0) {
            for (int i = 0; i < 4 - b.length % 4; ++i) {
                emf.writeBYTE(0);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\n  length: " + this.comment.length();
    }

    @Override
    public void render(EMFRenderer renderer) {
    }
}

