/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.trace;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SimpleLogFormatter
extends Formatter {
    private DateFormat formatter_ = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
    public final String lineSeperator__ = SimpleLogFormatter.getLineSeparator();
    private StringBuilder stringBuffer_ = new StringBuilder(256);
    private Date date_ = new Date();
    private static String traceSuffix__ = "[pdq]";
    private boolean userLevelLog_ = false;

    public SimpleLogFormatter() {
    }

    public SimpleLogFormatter(boolean bl2) {
        this.userLevelLog_ = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord logRecord) {
        Object object;
        Object object2;
        String string = null;
        if (logRecord.getThrown() != null) {
            try {
                object2 = new StringWriter();
                object = new PrintWriter((Writer)object2);
                this.printNestedExceptions(logRecord.getThrown(), (PrintWriter)object);
                ((PrintWriter)object).close();
                string = ((StringWriter)object2).toString();
            }
            catch (Exception exception) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging("Error with output of exception descriptions.", exception, 10055);
            }
        }
        object2 = this;
        synchronized (object2) {
            Level level;
            this.stringBuffer_.setLength(0);
            if (this.userLevelLog_) {
                this.stringBuffer_.append("");
            } else {
                this.stringBuffer_.append(traceSuffix__);
            }
            this.date_.setTime(logRecord.getMillis());
            object = this.formatter_.format(this.date_);
            this.stringBuffer_.append('[');
            this.stringBuffer_.append((String)object);
            this.stringBuffer_.append(']');
            if (this.useInternalFormat(logRecord.getLevel())) {
                this.stringBuffer_.append('[');
                this.stringBuffer_.append(Thread.currentThread().getName());
                this.stringBuffer_.append(']');
            }
            if (Level.WARNING == (level = logRecord.getLevel())) {
                this.stringBuffer_.append(level.getName());
                this.stringBuffer_.append(": ");
            }
            if (this.useInternalFormat(logRecord.getLevel())) {
                if (logRecord.getSourceClassName() != null) {
                    this.stringBuffer_.append('[').append(logRecord.getSourceClassName()).append(']');
                } else {
                    this.stringBuffer_.append('[').append(logRecord.getLoggerName()).append(']');
                }
                if (logRecord.getSourceMethodName() != null) {
                    this.stringBuffer_.append('[').append(logRecord.getSourceMethodName()).append(']');
                }
            }
            this.stringBuffer_.append(' ');
            this.stringBuffer_.append(logRecord.getMessage());
            this.stringBuffer_.append(this.lineSeperator__);
            if (string != null) {
                this.stringBuffer_.append(string);
            }
        }
        return this.stringBuffer_.toString();
    }

    private boolean useInternalFormat(Level level) {
        return level == Level.FINE || level == Level.FINER || level == Level.FINEST;
    }

    public void printNestedExceptions(Throwable throwable, PrintWriter printWriter) {
        throwable.printStackTrace(printWriter);
        printWriter.println();
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            while ((sQLException = sQLException.getNextException()) != null) {
                printWriter.println("Next exception:");
                sQLException.printStackTrace(printWriter);
                printWriter.println();
            }
        }
        while ((throwable = throwable.getCause()) != null) {
            throwable.printStackTrace(printWriter);
            printWriter.println();
        }
    }

    private static String getLineSeparator() {
        return System.getProperty("line.separator");
    }
}

