/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.itertools.IsliceBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.IsliceBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PIslice;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIslice})
public final class IsliceBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = IsliceBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IsliceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PIslice self, Object state, @Bind Node inliningTarget, @Cached CastToJavaIntLossyNode castInt, @Cached PRaiseNode raiseNode) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            try {
                self.setCnt(castInt.execute(inliningTarget, state));
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isNone(self.getIterable())"})
        static Object reduceNoIterable(VirtualFrame frame, PIslice self, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached PyObjectGetIter getIter, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, new Object[]{getIter.execute((Frame)frame, inliningTarget, PFactory.createList(language)), 0});
            return PFactory.createTuple(language, new Object[]{type, tuple, 0});
        }

        @Specialization(guards={"!isNone(self.getIterable())"})
        static Object reduce(PIslice self, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            Object type = getClassNode.execute(inliningTarget, self);
            PNone stop = self.getStop() == -1 ? PNone.NONE : Integer.valueOf(self.getStop());
            PTuple tuple = PFactory.createTuple(language, new Object[]{self.getIterable(), self.getNext(), stop, self.getStep()});
            return PFactory.createTuple(language, new Object[]{type, tuple, self.getCnt()});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"isNone(self.getIterable())"})
        static Object next(PIslice self) {
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!isNone(self.getIterable())"})
        static Object next(VirtualFrame frame, PIslice self, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedBranchProfile setNextProfile) {
            Object it = self.getIterable();
            TpSlot iterNext = getSlots.execute(inliningTarget, it).tp_iternext();
            int stop = self.getStop();
            try {
                while (loopProfile.profile(inliningTarget, self.getCnt() < self.getNext())) {
                    callIterNext.execute(frame, inliningTarget, iterNext, it);
                    self.setCnt(self.getCnt() + 1);
                }
                if (stop != -1 && self.getCnt() >= stop) {
                    self.setIterable(PNone.NONE);
                    throw NextNode.iteratorExhausted();
                }
                Object item = callIterNext.execute(frame, inliningTarget, iterNext, it);
                self.setCnt(self.getCnt() + 1);
                int oldNext = self.getNext();
                self.setNext(self.getNext() + self.getStep());
                if (self.getNext() < oldNext || stop != -1 && self.getNext() > stop) {
                    setNextProfile.enter(inliningTarget);
                    self.setNext(stop);
                }
                return item;
            }
            catch (IteratorExhausted | PException e) {
                self.setIterable(PNone.NONE);
                throw e;
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PIslice self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="islice", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class IsliceNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static Object constructOne(VirtualFrame frame, Object cls, Object[] args, PKeyword[] keywords, @Bind Node inliningTarget, @Cached(inline=false) TypeNodes.HasObjectInitNode hasObjectInitNode, @Cached PyObjectGetIter getIter, @Cached PyNumberAsSizeNode asIntNode, @Cached InlinedBranchProfile hasStart, @Cached InlinedBranchProfile hasStop, @Cached InlinedBranchProfile hasStep, @Cached InlinedBranchProfile stopNotInt, @Cached InlinedBranchProfile startNotInt, @Cached InlinedBranchProfile stopWrongValue, @Cached InlinedBranchProfile stepWrongValue, @Cached InlinedBranchProfile wrongValue, @Cached InlinedBranchProfile overflowBranch, @Cached InlinedConditionProfile argsLen1, @Cached InlinedConditionProfile argsLen2, @Cached InlinedConditionProfile argsLen3, @Cached InlinedBranchProfile wrongTypeBranch, @Cached InlinedBranchProfile wrongArgsBranch, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                wrongTypeBranch.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            if (keywords.length > 0 && hasObjectInitNode.executeCached(cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "islice()");
            }
            if (args.length < 2 || args.length > 4) {
                wrongArgsBranch.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ISLICE_WRONG_ARGS);
            }
            int start = 0;
            int step = 1;
            int stop = -1;
            if (argsLen1.profile(inliningTarget, args.length == 2)) {
                if (args[1] != PNone.NONE) {
                    hasStop.enter(inliningTarget);
                    try {
                        stop = asIntNode.executeExact((Frame)frame, inliningTarget, args[1], PythonBuiltinClassType.OverflowError);
                    }
                    catch (PException e) {
                        stopNotInt.enter(inliningTarget);
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_FOR_ISLICE_MUST_BE, "Indices");
                    }
                }
                if (stop < -1 || stop > Integer.MAX_VALUE) {
                    stopWrongValue.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_FOR_ISLICE_MUST_BE, "Indices");
                }
            } else if (argsLen2.profile(inliningTarget, args.length == 3) || argsLen3.profile(inliningTarget, args.length == 4)) {
                if (args[1] != PNone.NONE) {
                    hasStart.enter(inliningTarget);
                    try {
                        start = asIntNode.executeExact((Frame)frame, inliningTarget, args[1], PythonBuiltinClassType.OverflowError);
                    }
                    catch (PException e) {
                        startNotInt.enter(inliningTarget);
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_FOR_ISLICE_MUST_BE, "Indices");
                    }
                }
                if (args[2] != PNone.NONE) {
                    hasStop.enter(inliningTarget);
                    try {
                        stop = asIntNode.executeExact((Frame)frame, inliningTarget, args[2], PythonBuiltinClassType.OverflowError);
                    }
                    catch (PException e) {
                        stopNotInt.enter(inliningTarget);
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_FOR_ISLICE_MUST_BE, "Stop argument");
                    }
                }
                if (start < 0 || stop < -1 || start > Integer.MAX_VALUE || stop > Integer.MAX_VALUE) {
                    wrongValue.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_FOR_ISLICE_MUST_BE, "Indices");
                }
            }
            if (argsLen3.profile(inliningTarget, args.length == 4)) {
                if (args[3] != PNone.NONE) {
                    hasStep.enter(inliningTarget);
                    try {
                        step = asIntNode.executeExact((Frame)frame, inliningTarget, args[3], PythonBuiltinClassType.OverflowError);
                    }
                    catch (PException e) {
                        overflowBranch.enter(inliningTarget);
                        step = -1;
                    }
                }
                if (step < 1) {
                    stepWrongValue.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.STEP_FOR_ISLICE_MUST_BE);
                }
            }
            Object iterable = args[0];
            PIslice self = PFactory.createIslice(language, cls, getInstanceShape.execute(cls));
            self.setIterable(getIter.execute((Frame)frame, inliningTarget, iterable));
            self.setNext(start);
            self.setStop(stop);
            self.setStep(step);
            self.setCnt(0);
            return self;
        }
    }
}

