/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictValuesBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.DictValuesBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDictValuesView})
public final class DictValuesBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DictValuesBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictValuesBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doPDictValuesView(PDictView.PDictValuesView self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIter, @Bind PythonLanguage language) {
            HashingStorage storage = self.getWrappedStorage();
            return PFactory.createDictValueIterator(language, getReverseIter.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doPDictValuesView(PDictView.PDictValuesView self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Bind PythonLanguage language) {
            HashingStorage storage = self.getWrappedStorage();
            return PFactory.createDictValueIterator(language, getIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.sq_length)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        static int run(PDictView self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, self.getWrappedStorage());
        }
    }

    @Builtin(name="mapping", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class MappingNode
    extends PythonUnaryBuiltinNode {
        MappingNode() {
        }

        @Specialization
        static Object mapping(PDictView self, @Bind PythonLanguage language) {
            return PFactory.createMappingproxy(language, self.getWrappedDict());
        }
    }
}

