
#ifndef LAYERSHELLQT_EXPORT_H
#define LAYERSHELLQT_EXPORT_H

#ifdef LAYERSHELLQTINTERFACE_STATIC_DEFINE
#  define LAYERSHELLQT_EXPORT
#  define LAYERSHELLQTINTERFACE_NO_EXPORT
#else
#  ifndef LAYERSHELLQT_EXPORT
#    ifdef LayerShellQtInterface_EXPORTS
        /* We are building this library */
#      define LAYERSHELLQT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define LAYERSHELLQT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef LAYERSHELLQTINTERFACE_NO_EXPORT
#    define LAYERSHELLQTINTERFACE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef LAYERSHELLQTINTERFACE_DECL_DEPRECATED
#  define LAYERSHELLQTINTERFACE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef LAYERSHELLQTINTERFACE_DECL_DEPRECATED_EXPORT
#  define LAYERSHELLQTINTERFACE_DECL_DEPRECATED_EXPORT LAYERSHELLQT_EXPORT LAYERSHELLQTINTERFACE_DECL_DEPRECATED
#endif

#ifndef LAYERSHELLQTINTERFACE_DECL_DEPRECATED_NO_EXPORT
#  define LAYERSHELLQTINTERFACE_DECL_DEPRECATED_NO_EXPORT LAYERSHELLQTINTERFACE_NO_EXPORT LAYERSHELLQTINTERFACE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef LAYERSHELLQTINTERFACE_NO_DEPRECATED
#    define LAYERSHELLQTINTERFACE_NO_DEPRECATED
#  endif
#endif

#define LAYERSHELLQTINTERFACE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(LAYERSHELLQTINTERFACE_NO_DEPRECATED)
#  undef LAYERSHELLQTINTERFACE_DEPRECATED
#  define LAYERSHELLQTINTERFACE_DEPRECATED_EXPORT LAYERSHELLQT_EXPORT
#  define LAYERSHELLQTINTERFACE_DEPRECATED_NO_EXPORT LAYERSHELLQTINTERFACE_NO_EXPORT
#elif defined(LAYERSHELLQTINTERFACE_NO_DEPRECATED_WARNINGS)
#  define LAYERSHELLQTINTERFACE_DEPRECATED
#  define LAYERSHELLQTINTERFACE_DEPRECATED_EXPORT LAYERSHELLQT_EXPORT
#  define LAYERSHELLQTINTERFACE_DEPRECATED_NO_EXPORT LAYERSHELLQTINTERFACE_NO_EXPORT
#else
#  define LAYERSHELLQTINTERFACE_DEPRECATED LAYERSHELLQTINTERFACE_DECL_DEPRECATED
#  define LAYERSHELLQTINTERFACE_DEPRECATED_EXPORT LAYERSHELLQTINTERFACE_DECL_DEPRECATED_EXPORT
#  define LAYERSHELLQTINTERFACE_DEPRECATED_NO_EXPORT LAYERSHELLQTINTERFACE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define LAYERSHELLQTINTERFACE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define LAYERSHELLQTINTERFACE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef LAYERSHELLQTINTERFACE_NO_DEPRECATED
#  define LAYERSHELLQTINTERFACE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60600
#endif
#ifdef LAYERSHELLQTINTERFACE_NO_DEPRECATED_WARNINGS
#  define LAYERSHELLQTINTERFACE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef LAYERSHELLQTINTERFACE_DEPRECATED_WARNINGS_SINCE
#  ifdef LAYERSHELLQTINTERFACE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define LAYERSHELLQTINTERFACE_DEPRECATED_WARNINGS_SINCE LAYERSHELLQTINTERFACE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define LAYERSHELLQTINTERFACE_DEPRECATED_WARNINGS_SINCE 0x60600
#  endif
#endif

#ifndef LAYERSHELLQTINTERFACE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define LAYERSHELLQTINTERFACE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60000
#endif

#ifdef LAYERSHELLQTINTERFACE_DEPRECATED
#  define LAYERSHELLQTINTERFACE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > LAYERSHELLQTINTERFACE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define LAYERSHELLQTINTERFACE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if LAYERSHELLQTINTERFACE_DEPRECATED_WARNINGS_SINCE >= 0x60600
#  define LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_6_6(text) LAYERSHELLQTINTERFACE_DECL_DEPRECATED_TEXT(text)
#else
#  define LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_6_6(text)
#endif
#define LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_6(minor, text)      LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_6_##minor(text)
#define LAYERSHELLQTINTERFACE_DEPRECATED_VERSION(major, minor, text) LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define LAYERSHELLQTINTERFACE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) LAYERSHELLQTINTERFACE_DEPRECATED_VERSION(major, minor, text)
#  define LAYERSHELLQTINTERFACE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) LAYERSHELLQTINTERFACE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define LAYERSHELLQTINTERFACE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define LAYERSHELLQTINTERFACE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* LAYERSHELLQT_EXPORT_H */
