/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import jakarta.persistence.criteria.Nulls;
import org.hibernate.metamodel.mapping.ordering.ast.Node;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.sql.FakeSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.expression.SqmSelfRenderingExpression;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;

public interface OrderingExpression
extends Node {
    public SqlAstNode resolve(QuerySpec var1, TableGroup var2, String var3, SqlAstCreationState var4);

    public String toDescriptiveText();

    @Deprecated(since="7.0", forRemoval=true)
    default public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortDirection sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        this.apply(ast, tableGroup, collation, modelPartName, sortOrder, nullPrecedence.getJpaValue(), creationState);
    }

    public void apply(QuerySpec var1, TableGroup var2, String var3, String var4, SortDirection var5, Nulls var6, SqlAstCreationState var7);

    public static Expression applyCollation(Expression expression, String collation, SqlAstCreationState creationState) {
        Expression sortExpression;
        if (collation == null) {
            sortExpression = expression;
        } else {
            SqmToSqlAstConverter sqmToSqlAstConverter;
            QueryEngine queryEngine = creationState.getSqmCreationContext().getQueryEngine();
            if (creationState instanceof SqmToSqlAstConverter) {
                SqmToSqlAstConverter sqmToSqlAstConverter2 = (SqmToSqlAstConverter)creationState;
                sqmToSqlAstConverter = sqmToSqlAstConverter2;
            } else {
                sqmToSqlAstConverter = new FakeSqmToSqlAstConverter(creationState);
            }
            SqmToSqlAstConverter converter = sqmToSqlAstConverter;
            sortExpression = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("collate").generateSqmExpression(new SqmSelfRenderingExpression(walker -> expression, null, null), null, queryEngine).convertToSqlAst(converter);
        }
        return sortExpression;
    }
}

