/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.temptable;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;

public class TemporaryTableColumn
implements SqlTypedMapping {
    private final TemporaryTable containingTable;
    private final String columnName;
    private final JdbcMapping jdbcMapping;
    private final String sqlTypeName;
    private final Size size;
    private final boolean nullable;
    private final boolean primaryKey;

    public TemporaryTableColumn(TemporaryTable containingTable, String columnName, JdbcMapping jdbcMapping, String sqlTypeName, Size size, boolean nullable) {
        this(containingTable, columnName, jdbcMapping, sqlTypeName, size, nullable, false);
    }

    public TemporaryTableColumn(TemporaryTable containingTable, String columnName, JdbcMapping jdbcMapping, String sqlTypeName, Size size, boolean nullable, boolean primaryKey) {
        this.containingTable = containingTable;
        this.columnName = columnName;
        this.jdbcMapping = jdbcMapping;
        this.sqlTypeName = sqlTypeName;
        this.size = size;
        this.nullable = nullable;
        this.primaryKey = primaryKey;
    }

    public TemporaryTable getContainingTable() {
        return this.containingTable;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getSqlTypeDefinition() {
        return this.sqlTypeName;
    }

    public Size getSize() {
        return this.size;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public @Nullable String getColumnDefinition() {
        return this.sqlTypeName;
    }

    @Override
    public @Nullable Long getLength() {
        return this.size.getLength();
    }

    @Override
    public @Nullable Integer getPrecision() {
        return this.size.getPrecision();
    }

    @Override
    public @Nullable Integer getScale() {
        return this.size.getScale();
    }

    @Override
    public @Nullable Integer getTemporalPrecision() {
        return this.getJdbcMapping().getJdbcType().isTemporal() ? this.size.getPrecision() : null;
    }
}

