/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

public class MidiInstrumentEntry
implements Comparable<MidiInstrumentEntry> {
    private int midiBank;
    private int midiProgram;

    public MidiInstrumentEntry(int n, int n2) {
        if (n < 0 || n > 16129) {
            throw new IndexOutOfBoundsException("midiBank is out of range");
        }
        if (n2 < 0 || n2 > 127) {
            throw new IndexOutOfBoundsException("midiProgram is out of range");
        }
        this.midiBank = n;
        this.midiProgram = n2;
    }

    public int getMidiBank() {
        return this.midiBank;
    }

    public int getMidiProgram() {
        return this.midiProgram;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MidiInstrumentEntry)) {
            return false;
        }
        MidiInstrumentEntry midiInstrumentEntry = (MidiInstrumentEntry)object;
        return this.getMidiBank() == midiInstrumentEntry.getMidiBank() && this.getMidiProgram() == midiInstrumentEntry.getMidiProgram();
    }

    @Override
    public int compareTo(MidiInstrumentEntry midiInstrumentEntry) {
        if (this.getMidiBank() < midiInstrumentEntry.getMidiBank()) {
            return -1;
        }
        if (this.getMidiBank() > midiInstrumentEntry.getMidiBank()) {
            return 1;
        }
        if (this.getMidiProgram() < midiInstrumentEntry.getMidiProgram()) {
            return -1;
        }
        if (this.getMidiProgram() > midiInstrumentEntry.getMidiProgram()) {
            return 1;
        }
        return 0;
    }
}

