/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.daemon.client.clientinput;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.console.UserInputReceiver;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.InputMessage;
import org.gradle.launcher.daemon.protocol.UserResponse;

public class DaemonClientInputForwarder
implements Stoppable {
    private final ForwardingUserInput forwarder;
    private final GlobalUserInputReceiver userInput;
    private final ExecutorService executor;

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super InputMessage> dispatch, GlobalUserInputReceiver userInput) {
        this.userInput = userInput;
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.forwarder = new ForwardingUserInput(inputStream, dispatch, this.executor);
        userInput.dispatchTo((UserInputReceiver)this.forwarder);
    }

    public void stop() {
        this.userInput.stopDispatching();
        this.forwarder.stop();
        this.executor.shutdown();
    }

    private static class ForwardingUserInput
    implements UserInputReceiver {
        private final Dispatch<? super InputMessage> dispatch;
        private final BufferedReader reader;
        private final Executor executor;
        private char[] buffer;
        private final Object lock = new Object();
        private boolean closed;

        public ForwardingUserInput(InputStream inputStream, Dispatch<? super InputMessage> dispatch, Executor executor) {
            this.dispatch = dispatch;
            this.reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
            this.executor = executor;
        }

        public void readAndForwardStdin() {
            this.executor.execute(() -> {
                int nread;
                if (this.buffer == null) {
                    this.buffer = new char[16384];
                }
                try {
                    nread = this.reader.read(this.buffer);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                if (nread < 0) {
                    this.maybeClosed();
                } else {
                    String text = new String(this.buffer, 0, nread);
                    byte[] result = text.getBytes(Charset.defaultCharset());
                    ForwardInput message = new ForwardInput(result);
                    this.dispatch.dispatch((Object)message);
                }
            });
        }

        public void readAndForwardText(UserInputReceiver.Normalizer normalizer) {
            this.executor.execute(() -> {
                block3: {
                    String input;
                    String normalized;
                    do {
                        try {
                            input = this.reader.readLine();
                        }
                        catch (IOException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                        if (input != null) continue;
                        this.maybeClosed();
                        break block3;
                    } while ((normalized = normalizer.normalize(input)) == null);
                    this.dispatch.dispatch((Object)new UserResponse(normalized));
                }
            });
        }

        void stop() {
            this.maybeClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeClosed() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    CloseInput message = new CloseInput();
                    this.dispatch.dispatch((Object)message);
                    this.closed = true;
                }
            }
        }
    }
}

