/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane;

import de.sciss.syntaxpane.Token;
import java.io.Serializable;
import java.util.Comparator;

public class TokenComparators {
    public static final Comparator<Token> LONGEST_FIRST = new LongestFirst();
    public static final Comparator<Token> SHORTEST_FIRST = new ShortestFirst();

    private static class ShortestFirst
    implements Comparator<Token>,
    Serializable {
        private ShortestFirst() {
        }

        @Override
        public int compare(Token t1, Token t2) {
            if (t1.start != t2.start) {
                return t1.start - t2.start;
            }
            if (t1.length != t2.length) {
                return t1.length - t2.length;
            }
            return t1.type.compareTo(t2.type);
        }
    }

    private static class LongestFirst
    implements Comparator<Token>,
    Serializable {
        private LongestFirst() {
        }

        @Override
        public int compare(Token t1, Token t2) {
            if (t1.start != t2.start) {
                return t1.start - t2.start;
            }
            if (t1.length != t2.length) {
                return t2.length - t1.length;
            }
            return t1.type.compareTo(t2.type);
        }
    }
}

