/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IPostProcess;

public class PostProcessToClause
implements IPostProcess {
    private static final PostProcessToClause INSTANCE = new PostProcessToClause();
    private int assertiveLevel;

    private PostProcessToClause() {
    }

    public static final PostProcessToClause instance() {
        return INSTANCE;
    }

    @Override
    public void postProcess(int dl, ConflictMap conflictMap) {
        if (conflictMap.isAssertive(dl) && !conflictMap.degree.equals(BigInteger.ONE)) {
            conflictMap.setDecisionLevel(dl);
            if (conflictMap.assertiveLiteral != -1) {
                int i;
                conflictMap.assertiveLiteral = this.chooseAssertiveLiteral(dl, conflictMap);
                int lit = conflictMap.weightedLits.getLit(conflictMap.assertiveLiteral);
                VecInt toSuppress = new VecInt();
                for (i = 0; i < conflictMap.size(); ++i) {
                    int ilit = conflictMap.weightedLits.getLit(i);
                    int litLevel = conflictMap.voc.getLevel(ilit);
                    if (litLevel < this.assertiveLevel && conflictMap.voc.isFalsified(ilit)) {
                        conflictMap.weightedLits.changeCoef(i, BigInteger.ONE);
                        continue;
                    }
                    if (ilit == lit) continue;
                    toSuppress.push(ilit);
                }
                conflictMap.weightedLits.changeCoef(conflictMap.assertiveLiteral, BigInteger.ONE);
                for (i = 0; i < toSuppress.size(); ++i) {
                    conflictMap.removeCoef(toSuppress.get(i));
                }
                conflictMap.degree = BigInteger.ONE;
                conflictMap.assertiveLiteral = conflictMap.weightedLits.getFromAllLits(lit);
                assert (conflictMap.backtrackLevel == conflictMap.oldGetBacktrackLevel(dl));
            }
        }
    }

    public int chooseAssertiveLiteral(int maxLevel, ConflictMap conflictMap) {
        int indStop = ConflictMap.levelToIndex(maxLevel);
        int indStart = ConflictMap.levelToIndex(0);
        BigInteger slack = conflictMap.computeSlack(0).subtract(conflictMap.degree);
        int previous = 0;
        for (int indLevel = indStart; indLevel <= indStop; ++indLevel) {
            if (conflictMap.byLevel[indLevel] == null) continue;
            int level = ConflictMap.indexToLevel(indLevel);
            assert (conflictMap.computeSlack(level).subtract(conflictMap.degree).equals(slack));
            if (conflictMap.isImplyingLiteralOrdered(level, slack)) {
                conflictMap.backtrackLevel = previous;
                this.assertiveLevel = level;
                break;
            }
            VecInt lits = conflictMap.byLevel[indLevel];
            for (int lit : lits) {
                if (!conflictMap.voc.isFalsified(lit) || conflictMap.voc.getLevel(lit) != ConflictMap.indexToLevel(indLevel)) continue;
                slack = slack.subtract(conflictMap.weightedLits.get(lit));
            }
            if (lits.isEmpty()) continue;
            previous = level;
        }
        assert (conflictMap.backtrackLevel == conflictMap.oldGetBacktrackLevel(maxLevel));
        return conflictMap.assertiveLiteral;
    }

    public String toString() {
        return "Performs a post-processing after conflict analysis in order to learn clauses";
    }
}

