﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/chime-sdk-voice/model/PhoneNumberProductType.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class ListSupportedPhoneNumberCountriesRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API ListSupportedPhoneNumberCountriesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListSupportedPhoneNumberCountries"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  AWS_CHIMESDKVOICE_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The phone number product type.</p>
   */
  inline PhoneNumberProductType GetProductType() const { return m_productType; }
  inline bool ProductTypeHasBeenSet() const { return m_productTypeHasBeenSet; }
  inline void SetProductType(PhoneNumberProductType value) {
    m_productTypeHasBeenSet = true;
    m_productType = value;
  }
  inline ListSupportedPhoneNumberCountriesRequest& WithProductType(PhoneNumberProductType value) {
    SetProductType(value);
    return *this;
  }
  ///@}
 private:
  PhoneNumberProductType m_productType{PhoneNumberProductType::NOT_SET};
  bool m_productTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
