"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RangeInput = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const InputLabel_1 = require("./InputLabel");
const RangeInput_styles_1 = require("./RangeInput.styles");
exports.RangeInput = (0, react_1.forwardRef)((_a, ref) => {
    var { id = Math.random().toString(), label, minValueLabel, maxValueLabel, min = '0', max = '100', value = '0', onChange, wrapperCSS } = _a, inputProps = __rest(_a, ["id", "label", "minValueLabel", "maxValueLabel", "min", "max", "value", "onChange", "wrapperCSS"]);
    const minNum = Number(min);
    const maxNum = Number(max);
    const valueNum = Number(value);
    const backgroundSize = `${((valueNum - minNum) * 100) / (maxNum - minNum)}% 100%`;
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ css: wrapperCSS }, { children: [label && (0, jsx_runtime_1.jsx)(InputLabel_1.InputLabel, Object.assign({ htmlFor: id }, { children: label })), (0, jsx_runtime_1.jsxs)("div", Object.assign({ css: RangeInput_styles_1.rangeInputWrapperStyles }, { children: [minValueLabel && ((0, jsx_runtime_1.jsx)("span", Object.assign({ css: (theme) => (0, RangeInput_styles_1.getValueLabelStyles)(theme, RangeInput_styles_1.ValueLabelPosition.LEFT) }, { children: minValueLabel }))), maxValueLabel && ((0, jsx_runtime_1.jsx)("span", Object.assign({ css: (theme) => (0, RangeInput_styles_1.getValueLabelStyles)(theme, RangeInput_styles_1.ValueLabelPosition.RIGHT) }, { children: maxValueLabel }))), (0, jsx_runtime_1.jsx)("input", Object.assign({ ref: ref, css: (theme) => (0, RangeInput_styles_1.getImageCropZoomInputStyles)(theme, backgroundSize), id: id, name: id, min: min, max: max, value: value, onChange: onChange, type: "range" }, inputProps))] }))] })));
});
exports.RangeInput.displayName = 'RangeInput';
