/* -*- mode: C; tab-width:8; c-basic-offset:8 -*-
 * vi:set ts=8:
 *
 * al_ext_capture.h
 *
 * Prototypes for audio recording extension
 */
#ifndef AL_EXT_CAPTURE_H_
#define AL_EXT_CAPTURE_H_

#include "al_ext_needed.h"
#include "al_types.h"

#include <AL/alext.h>

/* functions needed by the regular library implementing extensions. */
void FL_alLockCapture(const char *fn, int ln);
void FL_alUnlockCapture(const char *fn, int ln);
#define _alLockCapture()       FL_alLockCapture(__FILE__, __LINE__)
#define _alUnlockCapture()     FL_alUnlockCapture(__FILE__, __LINE__)

/*
 * _alIsCapture( ALuint cpid )
 *
 * Returns AL_TRUE if cpid is a valid capture id, AL_FALSE otherwise.
 */
ALboolean _alIsCapture( ALuint cpid );

/*
 * _alGetCapture( ALuint cpid )
 * 
 * Returns a pointer to the AL_capture with name cpid, or NULL if cpid is
 * invalid.
 */
AL_capture *_alGetCapture( ALuint cpid );

/*
 * _alCaptureAppendData( AL_capture *cap,
 *                       ALvoid *capture_buffer, ALuint bytes )
 *
 * Append bytes worth of data ( in bytes) from capture_buffer to cap.
 */
void _alCaptureAppendData( AL_capture *cap,
			   ALvoid *capture_buffer, ALuint bytes );

/*
 * alInitCapture( void )
 *
 * Initializes data structures needed by all captures.
 */
void alInitCapture( void );

/*
 * alFiniCapture( void )
 *
 * Finalizes all things needing finalization by all captures.
 */
void alFiniCapture( void );

#ifndef OPENAL_EXTENSION

/*
 * we are being built into the standard library, so inform
 * the extension registrar
 */
#define BUILTIN_EXT_CAPTURE                                        \
	AL_EXT_PAIR(alGenCaptures_EXT),                            \
	AL_EXT_PAIR(alDeleteCaptures_EXT),                         \
	AL_EXT_PAIR(alCapturei_EXT),                               \
	AL_EXT_PAIR(alCaptureStart_EXT),                           \
	AL_EXT_PAIR(alCaptureStop_EXT),                            \
	AL_EXT_PAIR(alIsCapture_EXT),                              \
	AL_EXT_PAIR(alBufferRetrieveData_EXT)

/* initialization and destruction functions */

#define BUILTIN_EXT_CAPTURE_INIT  alInitCapture()
#define BUILTIN_EXT_CAPTURE_FINI  alFiniCapture()

#else

#define BUILTIN_EXT_CAPTURE_INIT
#define BUILTIN_EXT_CAPTURE_FINI

#endif /* OPENAL_EXTENSION */

#endif /* AL_EXT_CAPTURE_H_ */
