/****************************************************************************

   FILE: audioenv.h

   DESCRIPTION: header for audio environment class

****************************************************************************/

#include "switches.h"
#include "xlheader.h"

#if !defined (AUDIOENV)
#define AUDIOENV

class AudioEnv
{
private:
   ALuint buffer[256];
   ALuint source[256];
   ALuint nextBuffer, nextSource;
public:
   AudioEnv ();
   ~AudioEnv ();
   void Init ();
   void ListenerPosition (ALfloat*, ALfloat*);
#ifdef MACOS
   int LoadFile (const unsigned char *, bool, int bits, int rate, bool stereo);
   int PlayFile (const unsigned char *, bool, int bits, int rate, bool stereo);
#else
   int LoadFile (char *, bool);
   int PlayFile (char *, bool);
#endif
   void SetSourcePosition (int, float *);
   void Play (int);
   void Stop (int);
   int IncrementEnv();
};

typedef AudioEnv * AudioEnvPtr;

#endif // AUDIOENV

