/***************************************************************************
                          transaction.h  -  description
                             -------------------
    begin                : Sat Aug 10 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: transaction.h,v 1.7 2002/09/10 01:02:50 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSACTION_H
#define TRANSACTION_H

#include <qdatetime.h>
#include <qstring.h>

class KBudgetDoc;
class QTextStream;

/**A class that describes a transaction between two accounts
  *@author Richard Garand
  */

class Transaction {
  public:
    /** default constructor */
    Transaction();
    /** read data from a stream; version is the stream's format version */
    Transaction(KBudgetDoc* doc, int id, QTextStream &stream, int version);
    /** initialize a transaction object */
    Transaction(KBudgetDoc* doc, int id, int from, int to, float value, QDate date, QString description);
    /** default destructor */
    ~Transaction();

    /** writes the data to the stream */
    void serialize(QTextStream &stream);
    
    /** return the ID of the transactions */
    int id() const;
    /** return the ID of the account this is from */
    int from() const;
    /** return the ID of the account this is to */
    int to() const;
    /** get the value */
    float value() const;
    /** get the date */
    QDate date() const;
    /** get the description */
    QString description() const;
    
    /** set the value, date, and description */
    void setData(float value, QDate date, QString description);
    /** set the description */
    void setDescription(QString description);
  private:
	int m_from;
	int m_to;
	float m_value;
	QDate m_date;
	QString m_description;
	KBudgetDoc* m_doc;
	int m_id;
};

#endif
