// -*- c++ -*-
/***************************************************************************
                           channelpropertiesdialogimpl.h
                           -----------------------------
    begin                : Sat Apr 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __CHANNELPROPERTIESDIALOGIMPL_H
#define __CHANNELPROPERTIESDIALOGIMPL_H

#include "channelpropertiesdialog.h"

class Channel;
class SourceManager;

class ChannelPropertiesDialogImpl : public ChannelPropertiesDialog
{
    Q_OBJECT

public:
    ChannelPropertiesDialogImpl( Channel* channel, SourceManager* srcm, QWidget* parent = 0,
                                 const char* name = 0, bool modal = true, WFlags fl = 0 );
    ~ChannelPropertiesDialogImpl();


signals:
    void accepted();
    void rejected();


private slots:
    void freqUp();
    void freqDown();
    void freqChanged(double f);


private:
    virtual void accept();
    virtual void reject();

    Channel*       _c;
    SourceManager* _srcm;
};

#endif
