
// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef _QVIDEOSTREAM_H
#define _QVIDEOSTREAM_H


#include <qwidget.h>

class QVideoStreamPrivate;

#define QVIDEO_METHOD_NONE	0
#define QVIDEO_METHOD_XSHM	1
#define QVIDEO_METHOD_XV	2
#define QVIDEO_METHOD_XVSHM	4
#define QVIDEO_METHOD_X11	8
#define QVIDEO_METHOD_DGA	16 /* unimplemented */
#define QVIDEO_METHOD_GL	32 /* unimplemented */
#define QVIDEO_METHOD_SDL	64 /* unimplemented */


#define QVIDEO_FORMAT_NONE	0
#define QVIDEO_FORMAT_YUV2	1
#define QVIDEO_FORMAT_YV12	2
#define QVIDEO_FORMAT_I420	3
#define QVIDEO_FORMAT_UYVY	4
#define QVIDEO_FORMAT_GREY	5
#define QVIDEO_FORMAT_HI240	6
#define QVIDEO_FORMAT_RGB565	7
#define QVIDEO_FORMAT_RGB24	8
#define QVIDEO_FORMAT_RGB32	9
#define QVIDEO_FORMAT_RGB555	10
#define QVIDEO_FORMAT_YUYV	11


/**
 * QT-style video stream driver.
 *
 * @version $Id: qvideostream.h,v 1.7 2002/11/04 06:17:52 staikos Exp $
 */
class QVideoStream : public QObject
{
	Q_OBJECT

public:
	QVideoStream(QWidget *widget, const char* name = 0);
	~QVideoStream();

	bool scaling() const;
	void setScaling(bool scale);

	/* output method */
	bool haveMethod(int method) const;
	int  method() const;
	int  setMethod(int method);

	/* max output sizes */
	QSize maxSize() const;
	int   maxWidth() const;
	int   maxHeight() const;

	/* output sizes */
	QSize size() const;
	int   width() const;
	int   height() const;

	QSize setSize(const QSize& sz);
	int   setWidth(int width);
	int   setHeight(int height);

	/* input sizes */
	QSize inputSize() const;
	int   inputWidth() const;
	int   inputHeight() const;

	QSize setInputSize(const QSize& sz);
	int setInputWidth(int width);
	int setInputHeight(int height);
	
	/* input formats */
	int format() const;
	int setFormat(int format);

	QVideoStream& operator<<(const unsigned char *const img);

public slots:
	int displayFrame(const unsigned char *const img);

private:
	QVideoStreamPrivate *d;
	QWidget *_w;
	bool _scale;
	int _methods; // list of methods
	int _method;  // the current method
	QSize _size;
	QSize _inputSize;
	bool _init;

	void deInit();
	void init();
};

#endif

