/* ============================================================
 * File  : kexifwidget.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-14
 * Description : 
 * 
 * Copyright 2004 by Renchi Raju

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#include <qlayout.h>

#include "kexifdata.h"
#include "kexififd.h"
#include "kexiflistview.h"
#include "kexifwidget.h"

KExifWidget::KExifWidget(QWidget* parent, const char* name)
    : QWidget(parent, name), m_mode(KExifWidget::SIMPLE)
{
    m_data = new KExifData;

    QVBoxLayout* lay = new QVBoxLayout(this);
    m_view = new KExifListView(this);
    lay->addWidget(m_view);
}

KExifWidget::~KExifWidget()
{
    delete m_data;
}

bool KExifWidget::loadFile(const QString& filename)
{
    m_view->clear();
    if (!m_data->readFromFile(filename))
        return false;
    
    buildView();
    return true;
}

bool KExifWidget::loadData(char *data, int size)
{
    m_view->clear();
    if (!m_data->readFromData(data, size))
        return false;
    
    buildView();
    return true;
}

KExifData* KExifWidget::exifData() const
{
    return m_data;
}

void KExifWidget::setMode(KExifWidget::Mode mode)
{
    if (m_mode == mode)
        return;

    m_mode = mode;
    buildView();
}


QString KExifWidget::getCurrentItemName() const
{
    return m_view->getCurrentItemName();
}

void KExifWidget::setCurrentItem(const QString& itemName)
{
    m_view->setCurrentItem(itemName);    
}

void KExifWidget::buildView()
{
    m_view->clear();
    if (m_mode == SIMPLE)
    {
        QPtrList<KExifIfd> ifdList(m_data->ifdList());
        for (KExifIfd* ifd = ifdList.first(); ifd; ifd = ifdList.next())
        {
            if (ifd->getName().lower() == "exif")
            {
                QPtrList<KExifIfd> ifds;
                ifds.append(ifd);
                m_view->setIfdList(ifds);
                break;
            }
        }
    }
    else
    {
        m_view->setIfdList(m_data->ifdList());
    }
}

#include "kexifwidget.moc"
