/**
 * token.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "token.h"

#include <qptrlist.h>
#include <qcolor.h>
#include <qmap.h>

namespace KConfigEditor
{

Token::Token( const KURL &url, bool readOnly )
    : m_url( url )
{
    m_modified  = 0;
    m_immutable = false;
    m_readOnly  = readOnly;
    m_view      = 0;
}

Token::~Token()
{
}

void
Token::setReadOnly( bool r )
{
    m_readOnly = r;
}

bool
Token::readOnly() const
{
    return m_readOnly;
}

void
Token::setName( const QString & )
{
    Q_ASSERT( 0 );
}

QString
Token::name() const
{
    return m_url.fileName();
}

bool
Token::modified() const
{
    return m_modified;
}

void
Token::setImmutable( bool b )
{
    m_immutable = b;
}

bool
Token::immutable() const
{
    return m_immutable;
}

namespace Utils
{
    static QMap<QString, int> s_typeMap;

    void
    initTypeMap()
    {
        if ( s_typeMap.isEmpty() ) {
            s_typeMap.insert( "String",     Token::String );
            s_typeMap.insert( "Password",   Token::Password );
            s_typeMap.insert( "StringList", Token::StringList );
            s_typeMap.insert( "Font",       Token::Font );
            s_typeMap.insert( "Rect",       Token::Rect );
            s_typeMap.insert( "Size",       Token::Size );
            s_typeMap.insert( "Color",      Token::Color );
            s_typeMap.insert( "Point",      Token::Point );
            s_typeMap.insert( "Int",        Token::Int );
            s_typeMap.insert( "UInt",       Token::UInt );
            s_typeMap.insert( "Bool",       Token::Bool );
            s_typeMap.insert( "Double",     Token::Double );
            s_typeMap.insert( "DateTime",   Token::DateTime );
            s_typeMap.insert( "Int64",      Token::Int64 );
            s_typeMap.insert( "UInt64",     Token::UInt64 );
            s_typeMap.insert( "IntList",    Token::IntList );
            s_typeMap.insert( "Enum",       Token::Enum );
            s_typeMap.insert( "Path",       Token::Path );
            s_typeMap.insert( "Invalid",    Token::Invalid );
        }
    }

    Token::Type stringToType( const QString &typeName )
    {
        if ( s_typeMap.isEmpty() ) initTypeMap();
        if ( s_typeMap.contains( typeName ) )
            return static_cast<Token::Type>(  s_typeMap[ typeName ] );
        else return Token::Invalid;
    }
} //end namespace Utils

}
