/**
 * applicationtoken.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_APPLICATIONTOKEN_H
#define KONFIG_APPLICATIONTOKEN_H

#include "token.h"

#include <kurl.h>
#include <qptrlist.h>

namespace KCfgCreator
{
    class GroupToken;
    class ApplicationToken : public Token
    {
    public:
        typedef QPtrList<GroupToken>  GroupList;
        ApplicationToken( const KURL& url, const QString& name );
        ~ApplicationToken();

        /**
         * Returns the list of groups in this Application configuration.
         */
        GroupList groupList() const;

        /**
         * Returns a group witht the given name.
         */
        GroupToken* group( const QString& name ) const;

        void removeGroup( const QString& token );
        void removeGroup( GroupToken* );

        /**
         * Creates and returns a group (no undo action is created by this function)
         */
        GroupToken* createGroup( const QString& name, bool readOnly );

        /**
         * Returns the _writable_ config for this app.
         */
        KURL  url() const;
        void setURL( const KURL& );

        QStringList includeFiles() const;
        void addIncludeFile( const QString& file );
        void setIncludeList( const QStringList& );

        QStringList parameters() const;
        void addParameter( const QString& );

    private:
        GroupList m_groupList;

        KURL m_url;
        QStringList m_includeList;
        QStringList m_parameters;
    };
}

#endif
