/***************************************************************************
                          engine.cpp  -  description
                             -------------------
    begin                : Thu Feb 15 2001
    copyright            : (C) 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "engine.h"
#include "ksteak.h"

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kdatetbl.h>

#include <qtextview.h>
#include <qcursor.h>
#include <qregexp.h>

#include <stdio.h>
#include <stdlib.h>

Engine::Engine()
	: _fEnglish(false),
	  _fGerman(false),
	  _fContext(false),
	  _fSensitive(false),
	  _fSearchAnd(false),
	  _fSearchOr(false)
{
}

Engine::Engine( KConfig * pConfig )
{
	restoreStatus( pConfig );
}

/*******************************************
 * save config                             *
 *******************************************/
void Engine::saveStatus( KConfig * pConfig )
{
	pConfig->setGroup("General");
	pConfig->writeEntry( "English", _fEnglish);
	pConfig->writeEntry( "German", _fGerman);
	pConfig->writeEntry( "Context", _fContext);
	pConfig->writeEntry( "Sensitive", _fSensitive);
	pConfig->writeEntry( "SearchAnd", _fSearchAnd);
	pConfig->writeEntry( "SearchOr", _fSearchOr);
}

/*******************************************
 * read config                             *
 *******************************************/
void Engine::restoreStatus( KConfig * pConfig )
{
	pConfig->setGroup("General");
	_fEnglish = pConfig->readBoolEntry("English");
	_fGerman = pConfig->readBoolEntry("German");
	_fContext = pConfig->readBoolEntry("Context");
	_fSensitive = pConfig->readBoolEntry("Sensitive");
	_fSearchAnd = pConfig->readBoolEntry("SearchAnd");
	_fSearchOr = pConfig->readBoolEntry("SearchOr");
}

/*******************************************************/
/* write translation on display pView (in append mode) */
/*******************************************************/
void Engine::translate( const QString & szWord, QTextView * pView)
{
	FILE *fp;
	QString command;
	QString sline;
	char line[1024];
	bool first=true;
	szMaxLine="";
	unsigned int MaxLength=0;
	nRows = 1;

	/* set clock-cursor */
	KApplication::setOverrideCursor(Qt::waitCursor);

	/* setting up command */
	command="steak -nowait";
	if (_fEnglish & _fGerman)
		command.append(" -de");
	else if (_fGerman)
		command.append(" -d");
	else if (_fEnglish)
		command.append(" -e");
	if (!_fContext)
		command.append(" -k");
	if (_fSensitive)
		command.append(" -noignor");
	if (_fSearchAnd)
		command.append(" -and");
	if (_fSearchOr)
		command.append(" -or");

	command.append(" ");

	if ( ! szWord.isEmpty() )
	command.append( szWord );

	/* run shell process */
	if ((fp = popen(command, "r")) == NULL) 
	{
		fprintf(stderr, "popen error");
		exit(1);
	}

	/* read from stdout */
	while ((fgets(line, 1024, fp)) != NULL)
	{
		if (!first) pView->append("<BR>");				/* insert line break (display) */
		sline = line;
		sline.replace( QRegExp("\\d+\\s?.?"), "");		/* remove numbers at the begin of line */
		sline=sline.stripWhiteSpace();					/* remove whitespaces */
		int i = sline.find(":==");      				/* string match for ":==" */
		if ( i > 0 )
		{
			first = false;
			sline.remove(i, 4);							/* remove ":==" */
			if (i >= (int) MaxLength)					/* string befor :== */
			{
				szMaxLine=sline.left(i-1);				/* save max length */
			    MaxLength = i;
			}
			if (sline.length()-i > MaxLength)			/* string after :== */
			{
			    szMaxLine=" "+sline.right(sline.length()-i);
				MaxLength=sline.length()-i+1;			/* save max length */
			}
			sline.insert(0, "<U>");
			sline.insert(i+2, "</U><BR>");
			nRows+=2;									/* count rows */
			pView->append(sline);
		}

		/* find "kontext" */
		if (sline.contains("--- Jetzt die Kontext", TRUE))
		{
			pView->append("\n<B><U>"+i18n("Context")+"</U></B>");
			nRows++;
		}
	} 	/* end while loop (read stdout) */

	if (first)
	{
		sline = "no entry found - kein Eintrag";
		pView->append(sline);
		szMaxLine=sline+"H";
	}

	if (ferror(fp))
	printf("fgets error");
	pclose(fp);
	KApplication::restoreOverrideCursor();				/* restore cursor */
}

/**********************************************
 * write translation in a popup window        *
 **********************************************/
void Engine::translatePopup( const QString & szWord, QTextView * pView )
{
	int w, h, maxw, maxh;

	translate( szWord, pView );

	/* compute widget-size */
	QFont tFont = pView->font();
	QFontMetrics fm(tFont);
	w = fm.width(szMaxLine)+fm.width("HHH");
	h = fm.height()*(nRows+1);
	/* set max size */
	maxw = QApplication::desktop()->width()/2;
	maxh = QApplication::desktop()->height()/2;
	if ( w > maxw ) w=maxw+35;  /* wenn zu breit, dann platz fuer scrollbar */
	if ( h > maxh ) 			/* wenn zu hoch */
	{
		h=maxh;   				/* hoehe begrenzen */
		if (w<=maxw) w=w+35; 	/* ggf. platz fuer scrollbar */
	}
	/* set mix size */
	if ( h < 40 ) h=40;
	if ( w < 50 ) w=50;
	/* set widget-size */
	pView->resize(w,h);
}
