/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Fri Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dockwidget.h"
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qcursor.h>
#include <qclipboard.h>
#include <stdio.h>

/*************************************************
 * create dockwidget with popup-menu             *
 *************************************************/
dockwidget::dockwidget(QWidget *, const char * name) : KSystemTray(0, name)
{
  mypop = new KPopupFrame(this);						/* create Popup-window */
  mypop->setFrameStyle(QFrame::Box | QFrame::Plain);	/* we don't need decorations */
  mypop->setLineWidth(2); 								/* black frame */
  myview = new QTextView(mypop);						/* QTextView as display */
  myview->setFrameStyle(QFrame::NoFrame);				/* no decorations */

  popup_menu = new KPopupMenu(this);					/* popup menu */
  popup_menu->setTitle("KSteak");
  popup_menu->insertItem(SmallIcon("top"), i18n("Undock"), 1);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("configure"), i18n("Configure KSteak"), 2);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("viewmag"), i18n("Toggle Watching"), 4);
  popup_menu->insertSeparator();
  popup_menu->insertItem(SmallIcon("exit"), i18n("Quit"), 3);
  connect(popup_menu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));
}

/*************************************************
 * destructor                                    *
 *************************************************/
dockwidget::~dockwidget()
{
  delete popup_menu;
  delete mypop;
  delete myview;
}

/*************************************************
 * exec popup-menu on mousepressevent            *
 *************************************************/
void dockwidget::mousePressEvent(QMouseEvent* e)
{
  if (e->button() == RightButton) popup_menu->exec(QCursor::pos());	/* popup menu */
  if (e->button() == MidButton) emit toggleWatchCb();				/* toogle watching cb */
  if (e->button() == LeftButton)									/* translate */
  {
  	if (myview->hasSelectedText())
  		getTranslation( myview->selectedText() );
	else
		getTranslation( kapp->clipboard()->text() );
  }
}

/*************************************************
 * emit signals when (un-)dock                   *
 *************************************************/
void dockwidget::slotMenuClicked(int i)
{
  if (i == 1) emit undock();
  if (i == 2) emit configure();
  if (i == 3) emit done();
  if (i == 4) emit toggleWatchCb();
}

/*************************************************
 * get and show translations                     *
 *************************************************/
void dockwidget::getTranslation(const QString & szWord)
{
	int x, y;

	if (_fPopup)		/* popup at systray */
	{
		QPoint mpos = mapToGlobal(QPoint(this->x(), this->y()));
		x = mpos.x();
		y = mpos.y();
	}
	else				/* popup at cursor */
	{
		x = QCursor::pos().x();
		y = QCursor::pos().y();
	}
	/* get translation (engine) */
	emit translate( szWord );
	/* set size */
	int w = myview->width();
	int h = myview->height();
	/* clever placement */
	if (x-w < 1) w = 0;
	if (y-h < 1) h = 0;
	/* show popup window */
	mypop->setMainWidget( myview );
	mypop->popup( QPoint(x-w, y-h) );
}
