/***************************************************************************
                          textdlg.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <klocale.h>
#include "edittextdlg.h"
#include "kpldoubleedit.h"
#include "textdlg.h"
#include "textitem.h"

TextDlg::TextDlg(QWidget* _parent, KplDoc* model, TextItem* td0) :
 DecoDlg(_parent, i18n("Text"), "SEC-TEXT", model, td0, 4), td(td0)
{
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel(i18n("Text"), frame), 0, 0);
  grid->addMultiCellWidget(eText = new QLineEdit(td->s, frame), 0, 0, 1, 5);
  QPushButton* b = new QPushButton("...", frame);
  b->setFixedWidth(28);
  grid->addWidget(b, 0, 6);
  connect(b, SIGNAL(clicked()), SLOT(slotEditText()));
  grid->addWidget(new QLabel(i18n("Direction"), frame), 1, 0);
  grid->addWidget(eDir = new KplDoubleEdit(td->dir, -360.0, 360.0, frame),
                  1, 1);
  grid->addWidget(new QLabel("\260", frame), 1, 2);
  grid->addWidget(new QLabel(i18n("Alignment"), frame), 1, 4);
  grid->addWidget(eAlign = new QComboBox(false, frame), 1, 5);
  QStringList list;
  list << i18n("left") << i18n("centered") << i18n("right");
  eAlign->insertStringList(list);
  eAlign->setCurrentItem(td->iAlign - 1);
  initEntries(2);
}

TextDlg::~TextDlg()
{
}

void TextDlg::getValues(bool ok)
{
  td->dir = eDir->value();
  td->iAlign = eAlign->currentItem() + 1;
  td->s = eText->text();
  DecoDlg::getValues(ok);
}

void TextDlg::slotEditText()
{
  EditTextDlg dlg(this, eText);
  dlg.exec();
}

void TextDlg::slotOk()
{
  getValues(true);
}

void TextDlg::slotApply()
{
  getValues(false);
}
