/***************************************************************************
                          kplnamespace.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLNAMESPACE_H
#define KPLNAMESPACE_H

#define KPL_NPMAX 20

#include <qstring.h>

/**
  * Kpl namespace. Declares global names.
  * @author Werner Stille
  */
class KplNamespace
{
public:
  /** Structure contains data error fit settings for parameter fits. */
  struct DataErrorStruct {
    DataErrorStruct() : errModArg(1) {};
    bool fitErrCol;
    int errModArg;
    double pErrMod[KPL_NPMAX];
    QString errModName, errModPath;
  };
  /** Structure contains autoplot settings. */
  struct AutoStruct {
    AutoStruct() : autoErr(false), autoLogX(false), autoLogY(false), ixAuto(0),
      iyAuto(1), ieAuto(2), autoGrid(2), autoSymb(1), nyLeg(0), iDec(0),
      colFrame(0), colGrid(0), colData(0), xf(21.0), yf(29.7), x0Auto(4.0),
      xlAuto(15.0), y0Auto(3.0), ylAuto(10.0), relSize(1.0), sxAuto(""),
      syAuto(""), shAuto("") {};
    bool autoErr, autoNorm, autohPath, autoFit, fitShowDlg, fitSavePar,
         fitFollow, fitNonLin, showSource, autoLogX, autoLogY, addData;
    bool fitPar[KPL_NPMAX];
    int prec, ixAuto, iyAuto, ieAuto, autoGrid, autoSymb, fitMaxIt, fitSymb,
        nyLeg, iSep, iDec;
    unsigned colFrame, colGrid, colData, fitColor;
    double xf, yf, x0Auto, xlAuto, y0Auto, ylAuto, fitTol, relSize;
    double pFit[KPL_NPMAX];
    char format;
    QString sxAuto, syAuto, shAuto, fitName, fitPath;
    DataErrorStruct err;
  };
};

#endif
