/***************************************************************************
                          choosefuncdlg.h  -  description
                             -------------------
    begin                : Mit Jul 23 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHOOSEFUNCDLG_H
#define CHOOSEFUNCDLG_H

#include <kdialogbase.h>

class QFile;
class QLineEdit;
class QListBox;

/**
  * Choose function dialog class. Provides a dialog for the selection
  * of a function from list of functions in a shared library.
  * @author Werner Stille
  */
class ChooseFuncDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param f pointer to QFile opened for input from a file containing
   * a list of functions obtained using nm.
   * @param func pointer to QLineEdit widget for the function name.
   * @param d3 true in case of a 3D function.
   */
  ChooseFuncDlg(QWidget* parent, QFile* f, QLineEdit* func, bool d3 = false);
  /** Destructor. */
  ~ChooseFuncDlg();

protected:
  QLineEdit* func;
  QListBox* funcList;

protected slots:
  /**
   * Accepts selection and leaves the dialog.
   * @param i index of selected function
   */
  void slotList(int i);
  /** Accepts selection and leaves the dialog. */
  virtual void slotOk();
};

#endif
