/***************************************************************************
                          arcdlg.cpp  -  description
                             -------------------
    begin                : Sat Aug 17 2002
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include "arcdlg.h"
#include "arcitem.h"
#include "kpldoubleedit.h"

ArcDlg::ArcDlg(QWidget* _parent, KplDoc* model, ArcItem* ad0) :
 DecoDlg(_parent, i18n("Arc"), "SEC-ARC", model, ad0, 6), ad(ad0)
{
  setCaption(i18n("Arc"));
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel(i18n("Width"), frame), 0, 0);
  grid->addWidget(eWidth = new KplDoubleEdit(ad->width, 0.1, 200.0, frame),
                  0, 1);
  grid->addWidget(new QLabel("cm", frame), 0, 2);
  grid->addWidget(new QLabel(i18n("Height"), frame), 0, 4);
  grid->addWidget(eHeight = new KplDoubleEdit(ad->height, 0.1, 200.0, frame),
                  0, 5);
  grid->addWidget(new QLabel("cm", frame), 0, 6);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addMultiCellLayout(hbox, 1, 1, 1, 6);
  hbox->addWidget(isotropic = new QCheckBox(i18n("Circular arc"), frame));
  hbox->addItem(new QSpacerItem(10, 10, QSizePolicy::Expanding));
  connect(isotropic, SIGNAL(toggled(bool)), SLOT(slotAspect(bool)));
  isotropic->setChecked(ad->width == ad->height);
  grid->addWidget(new QLabel(i18n("Start"), frame), 2, 0);
  grid->addWidget(eA = new KplDoubleEdit(ad->a, -360.0, 360.0, frame),
                  2, 1);
  grid->addWidget(new QLabel("\260", frame), 2, 2);
  grid->addWidget(new QLabel(i18n("Length"), frame), 2, 4);
  grid->addWidget(eAlen = new KplDoubleEdit(ad->alen, -360.0, 360.0, frame),
                  2, 5);
  grid->addWidget(new QLabel("\260", frame), 2, 6);
  grid->addWidget(new QLabel(i18n("Rotation"), frame), 3, 0);
  grid->addWidget(eDir = new KplDoubleEdit(ad->dir, -360.0, 360.0, frame),
                  3, 1);
  grid->addWidget(new QLabel("\260", frame), 3, 2);
  initEntries(4);
  lSize->setText(i18n("Line width"));
}

ArcDlg::~ArcDlg()
{
}

void ArcDlg::getValues(bool ok)
{
  ad->width = eWidth->value();
  ad->height = isotropic->isChecked() ? ad->width : eHeight->value();
  ad->dir = eDir->value();
  ad->a = eA->value();
  ad->alen = eAlen->value();
  DecoDlg::getValues(ok);
}

void ArcDlg::slotAspect(bool iso)
{
  if (iso)
    eHeight->setValue(eWidth->value());
  eHeight->setDisabled(iso);
}

void ArcDlg::slotOk()
{
  getValues(true);
}

void ArcDlg::slotApply()
{
  getValues(false);
}
