/***************************************************************************
 *
 * knetworkmanager-vpnconnectionsdialog.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPNCONNECTIONSDIALOG_H
#define KNETWORKMANAGER_VPNCONNECTIONSDIALOG_H

#include <qobject.h>

#include "knetworkmanager.h"
#include "manageconnections.h"
#include "editconnection.h"
#include "authentication.h"
#include "knetworkmanager-vpnplugin.h"
#include "knetworkmanager-vpn.h"
#include "unknownservice.h"

class KNetworkManager;
class ManageConnectionsDialog;
class VPN;
class VPNConnection;
class VPNService;

class VPNEditConnectionDialog : public EditConnectionDialog
{
	Q_OBJECT
	public:
		VPNEditConnectionDialog(VPN* vpn, VPNConnection* conn = NULL, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
		~VPNEditConnectionDialog();

	public slots:
		void serviceSelected(int);
		void cancel();
		void ok();
		void done(int);

	signals:
		void done();

	private:
		VPNConfigWidget* showVPNWidget(const QString& );
		bool isValid(QStringList&);

		QMap<int, QString> _mapServiceCombo;
		QMap<QString, VPNConfigWidget*> _serviceWidgetMap;
		VPN* _vpn;
		VPNConnection* _vpnConnection;
		VPNConfigWidget* _vpnConfig;
		QWidget* _widgetInfo;
		UnknownServiceWidget* _widgetUnknownService;
};

class VPNConnectionsDialog : public ManageConnectionsDialog
{
	Q_OBJECT
	public:
		VPNConnectionsDialog( KNetworkManager* ctx, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
		~VPNConnectionsDialog();

	signals:
		void done();

	public slots:
		virtual void refreshList();
		void apply();

	protected slots:
		virtual void addConnection();
		virtual void editConnection();
		virtual void removeConnection();
		virtual void close();
		virtual void importConnection();
		virtual void done(int);
		virtual void connectionSelected(QListViewItem*);

	private:
		void importVPNConnection(QString&);
		void getAvailableConnections();
		VPN* _vpn;
		KNetworkManager* _ctx;
};

#endif /* KNETWORKMANAGER_VPNCONNECTIONSDIALOG_H */
