/***************************************************************************
 *
 * knetworkmanager-device.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICE_H
#define KNETWORKMANAGER_DEVICE_H

#include "knetworkmanager.h"
#include "knetworkmanager-network.h"
#include <NetworkManager/NetworkManager.h>

#include <stdint.h>

class KNetworkManager;
class Network;

typedef QValueList<Network *> NetworkList;

enum bustype {
	BUS_PCI		= 0,
	BUS_USB		= 1,
	BUS_PCMCIA	= 2,
	BUS_UNKNOWN	= 15 
};

class DevicePrivate;

class Device : public QObject
{
	Q_OBJECT
	public:
	  Device (const QString & );
	  Device ();
	  //Device ( const Device & );
	  ~Device ();

	  bool operator == (const Device &);

	  void         setInterface        (const QString&);
	  QString      getInterface        (void) const;
	  void         setBustype          (const QString&);
	  bustype      getBustype          (void) const;
	  void         setProduct          (const QString&);
	  QString      getProduct          (void) const;
	  void         setVendor           (const QString&);
	  QString      getVendor           (void) const;
	  void         setObjectPath       (const QString&);
	  QString      getObjectPath       (void) const;
	  void         setType             (const NMDeviceType &);
	  NMDeviceType getType             (void) const;
	  void         setUdi              (const QString&);
	  QString      getUdi              (void) const;
	  void         setActive           (bool);
	  bool         isActive            (void) const;
	  void         setActivationStage  (const NMActStage&);
	  NMActStage   getActivationStage  (void) const;
	  void         setIPv4Address      (const QString&);
	  QString      getIPv4Address      (void) const;
	  void         setSubnetmask       (const QString&);
	  QString      getSubnetmask       (void) const ;
	  void         setBroadcast        (const QString&);
	  QString      getBroadcast        (void) const;
	  void         setHardwareAddress  (const QString&);
	  QString      getHardwareAddress  (void) const;
	  void         setRoute            (const QString&);
	  QString      getRoute            (void) const;
	  void         setPrimaryDNS       (const QString&);
	  QString      getPrimaryDNS       (void) const;
	  void         setSecondaryDNS     (const QString&);
	  QString      getSecondaryDNS     (void) const;
	  void         setMode             (unsigned int);
	  unsigned int getMode             (void) const;
	  void         setStrength         (int);
	  int          getStrength         (void) const;
	  void         setLinkActive       (bool);
	  bool         getLinkActive       (void) const;
	  void         setSpeed            (int);
	  int          getSpeed            (void) const;
	  void         setCapabilities     (unsigned int);
	  unsigned int getCapabilities     (void) const;
	  void         setCapabilitiesType (unsigned int);
	  unsigned int getCapabilitiesType (void) const;
	  bool         hasCarrierDetect    (void) const;
	  void         setRxBytes          (uint64_t);
	  uint64_t     getRxBytes          (void) const;
	  void         setRxPackets        (uint64_t);
	  uint64_t     getRxPackets        (void) const;
	  void         setRxErrors         (uint64_t);
	  uint64_t     getRxErrors         (void) const;
	  void         setRxDropped        (uint64_t);
	  uint64_t     getRxDropped        (void) const;
	  void         setTxBytes          (uint64_t);
	  uint64_t     getTxBytes          (void) const;
	  void         setTxPackets        (uint64_t);
	  uint64_t     getTxPackets        (void) const;
	  void         setTxErrors         (uint64_t);
	  uint64_t     getTxErrors         (void) const;
	  void         setTxDropped        (uint64_t);
	  uint64_t     getTxDropped        (void) const;

	  void         setRxBytesPerSec    (uint32_t);
	  uint32_t     getRxBytesPerSec    (void) const;
	  void         setTxBytesPerSec    (uint32_t);
	  uint32_t     getTxBytesPerSec    (void) const;
	  void         setLastStatRefresh  (QDateTime);
	  QDateTime    getLastStatRefresh  (void) const;

	  void         addNetwork     (Network*);
	  void         removeNetwork  (Network*);
	  Network*     getNetwork     (const QString & obj_path) const;
	  NetworkList  getNetworkList (void) const;

	  void        setPendingNetwork   (Network *);
	  Network*    getPendingNetwork   (const QString &);
	  bool        pendingNetwork      (void);
	  void        clearPendingNetwork (void);

	  bool        isWired        (void);
	  bool        isWireless     (void);

	private:
	  DevicePrivate * d;
};

#endif /* KNETWORKMANAGER_DEVICE_H */
