/***************************************************************************
                          autodlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kglobal.h>
#include "autodlg.h"
#include "edittextdlg.h"
#include "symboldlg.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "utils.h"

AutoDlg::AutoDlg(QWidget* _parent, KplDoc* m0) :
 KDialogBase(Plain, i18n("Autoplot settings"), Help | Ok | Cancel, Ok, _parent),
 m(m0)
{
  a = new Kpl::AutoStruct(*m->options());
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QHBoxLayout* hbox = new QHBoxLayout(vbox);
  hbox->addWidget(bg = new QButtonGroup(0, Qt::Vertical, i18n("Axis mode"),
                                        frame), 0, 0);
  QVBoxLayout* vbox2 = new QVBoxLayout(bg->layout(), 16);
  vbox2->addWidget(new QRadioButton(i18n("Frame only"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics with numbers"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid with numbers"), bg));
  ((QRadioButton*) bg->find(a->autoGrid))->setChecked(true);
  vbox2 = new QVBoxLayout(hbox);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Window"), frame);
  vbox2->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 2, 7, spacingHint());
  grid->addWidget(new QLabel(i18n("Left margin"), g), 0, 0);
  grid->addWidget(autoX0 = new KplDoubleEdit(a->x0Auto, 0.0, 200.0, g), 0, 1);
  grid->addWidget(new QLabel("cm", g), 0, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel(i18n("Width"), g), 0, 4);
  grid->addWidget(autoXl = new KplDoubleEdit(a->xlAuto, 0.5, 200.0, g), 0, 5);
  grid->addWidget(new QLabel("cm", g), 0, 6);
  grid->addWidget(new QLabel(i18n("Bottom margin"), g), 1, 0);
  grid->addWidget(autoY0 = new KplDoubleEdit(a->y0Auto, 0.0, 200.0, g), 1, 1);
  grid->addWidget(new QLabel("cm", g), 1, 2);
  grid->addWidget(new QLabel(i18n("Height"), g), 1, 4);
  grid->addWidget(autoYl = new KplDoubleEdit(a->ylAuto, 0.5, 200.0, g), 1, 5);
  grid->addWidget(new QLabel("cm", g), 1, 6);
  vbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Labels"), frame));
  grid = new QGridLayout(g->layout(), 3, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("x axis"), g), 0, 0);
  grid->addWidget(autoLetX = new QLineEdit(a->sxAuto, g), 0, 1);
  QPushButton *b = new QPushButton("...", g);
  grid->addWidget(b, 0, 2);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetX()));
  grid->addWidget(new QLabel(i18n("y axis"), g), 1, 0);
  grid->addWidget(autoLetY = new QLineEdit(a->syAuto, g), 1, 1);
  grid->addWidget(b = new QPushButton("...", g), 1, 2);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetY()));
  grid->addWidget(new QLabel(i18n("Heading"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(autohPath = new QCheckBox(i18n("= path"), g));
  autohPath->setChecked(a->autohPath);
  hbox->addWidget(autoLetH = new QLineEdit(a->shAuto, g));
  grid->addWidget(editH = new QPushButton("...", g), 2, 2);
  editH->setFixedWidth(28);
  connect(editH, SIGNAL(clicked()), SLOT(slotEditLetH()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Data"), frame));
  grid = new QGridLayout(g->layout(), 3, 6, spacingHint());
  grid->addWidget(new QLabel(i18n("x column"), g), 0, 0);
  grid->addWidget(ix = new KplSpinBox(0, 19, 1, g), 0, 1);
  ix->setValue(a->ixAuto);
  grid->addWidget(logX = new QCheckBox("log", g), 0, 2);
  logX->setChecked(a->autoLogX);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel(i18n("y column"), g), 1, 0);
  grid->addWidget(iy = new KplSpinBox(0, 19, 1, g), 1, 1);
  iy->setValue(a->iyAuto);
  grid->addWidget(logY = new QCheckBox("log", g), 1, 2);
  logY->setChecked(a->autoLogY);
  grid->addWidget(new QLabel(i18n("Error column"), g), 2, 0);
  grid->addWidget(ie = new KplSpinBox(0, 19, 1, g), 2, 1);
  ie->setValue(a->ieAuto);
  ie->setEnabled(a->autoErr);
  grid->addWidget(err = new QCheckBox(i18n("Error bar"), g), 2, 2);
  err->setChecked(a->autoErr);
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 4);
  grid->addLayout(hbox = new QHBoxLayout(), 0, 5);
  hbox->addWidget(autoSymb = new KplSpinBox(-17, 9, 1, g));
  autoSymb->setValue(a->autoSymb);
  SymbolButton* bSymb = new SymbolButton(g, autoSymb);
  hbox->addWidget(bSymb);
  bSymb->setFixedWidth(50);
  grid->addWidget(autoNorm = new QCheckBox(i18n("Normalization"), g), 1, 5);
  autoNorm->setChecked(a->autoNorm);
  grid->addWidget(autoFit = new QCheckBox(i18n("Autofit"), g), 2, 5);
  autoFit->setChecked(a->autoFit);
  Utils::setSize(this, "AutoPlotDialog");
  setHelp("SEC-AUTOPLOT");
  connect(autohPath, SIGNAL(toggled(bool)), SLOT(disableHeading(bool)));
  connect(logX, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  connect(logY, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  connect(err, SIGNAL(toggled(bool)), ie, SLOT(setEnabled(bool)));
  connect(autoNorm, SIGNAL(toggled(bool)), SLOT(slotNormToggled(bool)));
  slotLogToggled(a->autoLogX || a->autoLogY);
  disableHeading(a->autohPath);
}

AutoDlg::~AutoDlg()
{
  Utils::saveSize(this, "AutoPlotDialog");
  delete a;
}

void AutoDlg::slotEditLetX()
{
  EditTextDlg::editText(this, autoLetX);
}

void AutoDlg::slotEditLetY()
{
  EditTextDlg::editText(this, autoLetY);
}

void AutoDlg::slotEditLetH()
{
  EditTextDlg::editText(this, autoLetH);
}

void AutoDlg::disableHeading(bool off)
{
  autoLetH->setEnabled(!off);
  editH->setEnabled(!off);
}

void AutoDlg::slotLogToggled(bool state)
{
  if (state)
    autoNorm->setChecked(false);
}

void AutoDlg::slotNormToggled(bool state)
{
  if (state) {
    logX->setChecked(false);
    logY->setChecked(false);
  }
}

void AutoDlg::slotOk()
{
  a->x0Auto = autoX0->value();
  a->y0Auto = autoY0->value();
  a->xlAuto = autoXl->value();
  a->ylAuto = autoYl->value();
  a->sxAuto = autoLetX->text();
  a->syAuto = autoLetY->text();
  a->shAuto = autoLetH->text();
  a->autohPath = autohPath->isChecked();
  a->autoFit = autoFit->isChecked();
  a->autoGrid = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg->find(++a->autoGrid);
  while (!rb->isChecked());
  a->ixAuto = ix->interpretedValue();
  a->iyAuto = iy->interpretedValue();
  a->ieAuto = ie->interpretedValue();
  a->autoLogX = logX->isChecked();
  a->autoLogY = logY->isChecked();
  a->autoErr = err->isChecked();
  a->autoSymb = autoSymb->interpretedValue();
  a->autoNorm = autoNorm->isChecked();
  m->setOptions(a);
  accept();
}
