/***************************************************************************
                          zoomdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include "kplspinbox.h"
#include "zoomdlg.h"

ZoomDlg::ZoomDlg(QWidget* _parent, int* f0) :
 KDialogBase(Plain, QString::null, Ok | Cancel, Ok, _parent, 0, true, true),
 f(f0)
{
  setPlainCaption(i18n("Zoom"));
  QFrame* frame = plainPage();
  QHBoxLayout* hbox = new QHBoxLayout(frame, 0, spacingHint());
  hbox->addWidget(new QLabel(i18n("Factor"), frame));
  hbox->addWidget(sb = new KplSpinBox(1, 2000, 1, frame));
  sb->setSuffix(" %");
  sb->setValue(*f);
}

ZoomDlg::~ZoomDlg()
{
}

void ZoomDlg::slotOk()
{
  *f = sb->interpretedValue();
  accept();
}
