/***************************************************************************
                          psgraph.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Wed Sep 08 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PSGRAPH_H
#define PSGRAPH_H

#include "kplgraph.h"

class QTextStream;

/**
  * PostScript graphics class. Provides high level plotting functionality.
  * @author Werner Stille
  */
class PSGraph : public KplGraph
{
public:
  /** Constructor */
  PSGraph();
  /** Destructor */
  virtual ~PSGraph();
  /** Points per cm */
  static const double pts;
  /**
   * Initializes PostScript graphics.
   * @param f pointer to stream opened for write access.
   * @param xf width of bounding box.
   * @param yf height of bounding box.
   */
  void psInit(QTextStream* ts, double xf, double yf);
  virtual void format(double x, double y);
  virtual void setColFrame(unsigned icol1);
  virtual void setColGrid(unsigned icol2);
  virtual void setColData(unsigned icol3);
  virtual void setCol(unsigned icol1, unsigned icol2, unsigned icol3);
  virtual double setRelSize(double r);
  virtual void Window(double x0, double xl, double y0, double yl);
  virtual void scale(double xl, double xr, double yu, double yo,
                     bool logx = false, bool logy = false);
  virtual void setDig(int nx, int ny);
  virtual void frame();
  virtual void raster(double xtic, double ytic, int intx, int inty,
                      int mode, double xOff = 0.0, double yOff = 0.0,
                      bool xBottom = true, bool xTop = false,
                      bool yLeft = true, bool yRight = false);
  virtual void setDir(double ang);
  virtual void textcm(const QString& str, double x, double y, int iorg,
                      QRect* bRect = 0);
  virtual void arrow(double x, double y, double dir, double len,
                     QRect* bRect = 0);
  virtual void arc(double x, double y, double w, double h, double a,
                   double alen, double dir = 0.0, QRect* bRect = 0);
  virtual void rectangle(double x, double y, double w, double h,
                         bool filled, double dir, QRect* bRect = 0);
  virtual void ellipse(double x, double y, double w, double h,
                       bool filled, double dir = 0.0, QRect* bRect = 0);
  virtual void letH(const QString& str, bool xTop);
  virtual void letX(const QString& str, int iex, bool xTop);
  virtual void letY(const QString& str, int iex, bool yRight);
  virtual void setSymbol(int is);
  virtual void plArray(const double* x, const double* y,
                       double fx, double fy, int n, bool clip = true);
  virtual void plError(const double* x, const double* y, const double* e,
                       double fx, double fy, int n);
  virtual void resetDash();
  /** Ends PostScript graphic and closes output stream. */
  void psExit();
  virtual void cm2r(double xcm, double ycm, double fxn, double fyn,
                    double* xr, double* yr) const;

protected:
  /**
   * Converts to PostScript string.
   * @param str text.
   */
  void psStr(const char* str);
  /**
   * Plots text.
   * @param str text.
   * @param x x value in points.
   * @param y y value in points.
   * @param iorg 1: left aligned, 2: centered, 3: right aligned.
   */
  void text(const QString& str, double x, double y, int iorg);
  double x0, xl, y0, yl, xmin, xmax, ymin, ymax;
  QTextStream* ts;
};

#endif
