/***************************************************************************
                          arcdlg.h  -  description
                             -------------------
    begin                : Sat Aug 17 2002
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARCDLG_H
#define ARCDLG_H

#include <decodlg.h>

class ArcItem;

/**
  * Arc settings dialog class. Provides a dialog for the settings
  * of an arc decoration item.
  * @author Werner Stille
  */
class ArcDlg : public DecoDlg
{
   Q_OBJECT
public: 
  ArcDlg(QWidget* parent, KplDoc* model, ArcItem* ad);
  ~ArcDlg();

protected:
  /**
   * Copies settings to rectangle item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  ArcItem* ad;
  KplDoubleEdit *eWidth, *eHeight, *eDir, *eA, *eAlen;

protected slots:
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
  /** Displays help for the arc settings dialog. */
  void slotHelp2();
};

#endif
